/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsmllib;

import cn.edu.suda.ngsmllib.Checker;
import cn.edu.suda.ngsmllib.NGSMLException;
import cn.edu.suda.ngsmllib.node.AttributeType;
import cn.edu.suda.ngsmllib.node.BasicAttribute;
import cn.edu.suda.ngsmllib.node.ChoiceElement;
import cn.edu.suda.ngsmllib.node.DefaultElement;
import cn.edu.suda.ngsmllib.node.NGSAttribute;
import cn.edu.suda.ngsmllib.node.NGSElement;
import cn.edu.suda.ngsmllib.node.NGSML;
import cn.edu.suda.ngsmllib.node.NGSNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class CheckFactory {
    private static final CheckFactory INSTANCE = new CheckFactory();
    public static final String version = "2.0";
    public static final String xmlns = "http://www.sysbio.org.cn/ngsml/version1";
    public static final String xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String xsi_schemaLocation = "http://www.sysbio.org.cn/ngsml/version1 http://www.sysbio.org.cn/ngsml/ngsml.xsd";
    public static final String refFileType = "NGSML";
    private NGSNode model;

    private CheckFactory() {
        this.init();
    }

    private void init() {
        this.model = new NGSML().build();
    }

    public static CheckFactory getInstance() {
        return INSTANCE;
    }

    public String getVersion() {
        return version;
    }

    public String getXmlns_xsi() {
        return xmlns_xsi;
    }

    public String getXsi_schemaLocation() {
        return xsi_schemaLocation;
    }

    public Document buildNew() {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("UTF-8");
        Element ngs = document.addElement("ngs", xmlns);
        ngs.addAttribute("version", version);
        ngs.addAttribute("xmlns:xsi", xmlns_xsi);
        ngs.addAttribute("xsi:schemaLocation", xsi_schemaLocation);
        ngs.addAttribute("refFileType", refFileType);
        return document;
    }

    public Document buildNewSAX() {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("UTF-8");
        Element ngs = document.addElement("ngs", xmlns);
        ngs.addAttribute("version", version);
        ngs.addAttribute("xmlns:xsi", xmlns_xsi);
        ngs.addAttribute("xsi:schemaLocation", xsi_schemaLocation);
        ngs.addAttribute("refFileType", refFileType);
        return document;
    }

    public boolean isValid(String xpath) {
        if (!xpath.startsWith("/")) {
            return false;
        }
        xpath = xpath.substring(1);
        String[] paths = xpath.split("/");
        if (!paths[0].equals(this.model.getName())) {
            return false;
        }
        NGSNode node = this.model;
        for (int i = 1; i < paths.length; ++i) {
            if (i == paths.length - 1 && paths[i].startsWith("@")) {
                paths[i] = paths[i].substring(1);
            }
            boolean match = false;
            block1: for (int j = 0; j < node.getChildCount(); ++j) {
                if (node.getChild(j).getName().equals(paths[i])) {
                    node = node.getChild(j);
                    match = true;
                    break;
                }
                if (node.getChild(j) instanceof ChoiceElement) {
                    for (int k = 0; k < node.getChild(j).getChildCount(); ++k) {
                        if (!node.getChild(j).getChild(k).getName().equals(paths[i])) continue;
                        node = node.getChild(j).getChild(k);
                        match = true;
                        continue block1;
                    }
                    continue;
                }
                match = false;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public NGSNode findNode(String xpath) throws NGSMLException {
        String s = xpath;
        if (!xpath.startsWith("/")) {
            throw new NGSMLException(s, "Invalid Path!", NGSMLException.Error.Default);
        }
        xpath = xpath.substring(1);
        String[] paths = xpath.split("/");
        if (!paths[0].equals(this.model.getName())) {
            throw new NGSMLException(s, "Invalid Root! Root is " + paths[0], NGSMLException.Error.InvalidElement);
        }
        NGSNode node = this.model;
        for (int i = 1; i < paths.length; ++i) {
            if (i == paths.length - 1 && paths[i].startsWith("@")) {
                paths[i] = paths[i].substring(1);
            }
            boolean match = false;
            block1: for (int j = 0; j < node.getChildCount(); ++j) {
                if (node.getChild(j).getName().equals(paths[i])) {
                    node = node.getChild(j);
                    match = true;
                    break;
                }
                if (node.getChild(j) instanceof ChoiceElement) {
                    for (int k = 0; k < node.getChild(j).getChildCount(); ++k) {
                        if (!node.getChild(j).getChild(k).getName().equals(paths[i])) continue;
                        node = node.getChild(j).getChild(k);
                        match = true;
                        continue block1;
                    }
                    continue;
                }
                match = false;
            }
            if (match) continue;
            throw new NGSMLException(s, "Invalid Element!", NGSMLException.Error.InvalidElement);
        }
        return node;
    }

    public Checker find(String xpath) throws NGSMLException {
        NGSNode node = this.findNode(xpath);
        if (node instanceof NGSAttribute) {
            BasicAttribute cnode = this.cloneAttr(node);
            Checker checker = new Checker(xpath, cnode, (AttributeType)((NGSAttribute)node).getValueType());
            return checker;
        }
        DefaultElement cnode = this.cloneElement(node);
        ArrayList<DefaultElement> elements = new ArrayList<DefaultElement>();
        ArrayList<BasicAttribute> attrs = new ArrayList<BasicAttribute>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            NGSNode child = node.getChild(i);
            if (child instanceof NGSAttribute) {
                attrs.add(this.cloneAttr(child));
                continue;
            }
            if (child instanceof ChoiceElement) {
                for (int j = 0; j < child.getChildCount(); ++j) {
                    NGSNode ch = child.getChild(j);
                    elements.add(this.cloneElement(ch));
                }
                continue;
            }
            if (!(child instanceof NGSElement)) continue;
            elements.add(this.cloneElement(child));
        }
        Checker checker = new Checker(xpath, cnode, elements, attrs);
        return checker;
    }

    public int check(Document doc) throws NGSMLException {
        Element root = doc.getRootElement();
        this.check(root);
        return 0;
    }

    private boolean check(Element ele) throws NGSMLException {
        this.checkSequence(ele);
        for (int i = 0; i < ele.attributeCount(); ++i) {
            Attribute a = ele.attribute(i);
            this.checkNode((Node)a);
        }
        for (int j = 0; j < ele.elements().size(); ++j) {
            Element e = (Element)ele.elements().get(j);
            this.checkNode((Node)e);
            this.check(e);
        }
        return true;
    }

    private boolean checkNode(Node n) throws NGSMLException {
        NGSAttribute a;
        String xpath = CheckFactory.detachNs(n.getPath());
        NGSNode node = this.findNode(xpath);
        if (node instanceof NGSElement) {
            NGSElement e = (NGSElement)node;
            if (!e.isText() && !n.getText().trim().isEmpty()) {
                throw new NGSMLException(xpath, e.getName() + " have content!", NGSMLException.Error.InvalidType);
            }
        } else if (node instanceof NGSAttribute && !(a = (NGSAttribute)node).getValueType().isValid(((Attribute)n).getValue())) {
            throw new NGSMLException(xpath, a.getName() + " wrong value type!", NGSMLException.Error.InvalidType);
        }
        return true;
    }

    private boolean checkSequence(Element parent) throws NGSMLException {
        NGSNode pnode = this.findNode(CheckFactory.detachNs(parent.getPath()));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < pnode.getChildCount(); ++i) {
            NGSNode child = pnode.getChild(i);
            if (child instanceof NGSAttribute && ((NGSAttribute)child).getUse() == NGSAttribute.AttributeUse.required && parent.attribute(child.getName()) == null) {
                throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), child.getName() + " is required!", NGSMLException.Error.InvalidElement);
            }
            if (!(child instanceof NGSElement)) continue;
            int no = ((NGSElement)child).getSeqno();
            int min = ((NGSElement)child).getMinCount();
            int max = ((NGSElement)child).getMaxCount();
            if (min == 1 && !child.getName().equals("choice") && parent.elements(child.getName()).size() < 1) {
                throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), child.getName() + " is required!", NGSMLException.Error.InvalidCount);
            }
            if (max == 1 && parent.elements(child.getName()).size() > 1) {
                throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), child.getName() + " is more than 1!", NGSMLException.Error.InvalidCount);
            }
            if (child.getName().equals("choice")) {
                map.put("origin", -1);
                map.put("file", -1);
            }
            map.put(child.getName(), no);
        }
        int currentNo = -2;
        for (int i = 0; i < parent.elements().size(); ++i) {
            Element e = (Element)parent.elements().get(i);
            Integer no = (Integer)map.get(e.getName());
            if (no == null) {
                throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), e.getName() + " is unknow element!", NGSMLException.Error.InvalidElement);
            }
            if (currentNo == -1) {
                if (no == -1) continue;
                throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), e.getName() + " is in wrong sequence!", NGSMLException.Error.WrongSequence);
            }
            if (no >= currentNo || no == -1) {
                currentNo = no;
                continue;
            }
            throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), e.getName() + " is in wrong sequence!", NGSMLException.Error.WrongSequence);
        }
        int n1 = parent.elements("origin").size();
        int n2 = parent.elements("file").size();
        if (n1 >= 1 && n2 >= 1) {
            throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), "Cannot exist togethor: origin and file!", NGSMLException.Error.InvalidElement);
        }
        String parentPath = CheckFactory.detachNs(parent.getPath());
        if ((parentPath.equals("/ngs/list_of_seqs/seq") || parentPath.equals("/ngs/list_of_quals/qual")) && n1 == 0 && n2 == 0) {
            throw new NGSMLException(CheckFactory.detachNs(parent.getPath()), "Must exist one: origin and file!", NGSMLException.Error.InvalidElement);
        }
        return true;
    }

    private static String detachNs(String xpath) {
        return xpath.replaceAll("/\\*\\[name\\(\\)='(\\w*)'\\]", "/$1");
    }

    private BasicAttribute cloneAttr(NGSNode node) {
        NGSAttribute attr = (NGSAttribute)node;
        BasicAttribute cloneNode = new BasicAttribute(attr.getName(), attr.getValueType());
        cloneNode.setDefaultValue(attr.getDefaultValue());
        cloneNode.setUse(attr.getUse());
        return cloneNode;
    }

    private DefaultElement cloneElement(NGSNode node) {
        NGSElement ele = (NGSElement)node;
        DefaultElement cloneNode = new DefaultElement(ele.getName());
        cloneNode.setMaxCount(ele.getMaxCount());
        cloneNode.setMinCount(ele.getMinCount());
        cloneNode.setSeqno(ele.getSeqno());
        cloneNode.setText(ele.isText());
        return cloneNode;
    }
}

