/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsmllib;

import cn.edu.suda.ngsmllib.node.AttributeType;
import cn.edu.suda.ngsmllib.node.BasicAttribute;
import cn.edu.suda.ngsmllib.node.DefaultElement;
import cn.edu.suda.ngsmllib.node.NGSNode;
import java.util.ArrayList;
import java.util.List;

public class Checker {
    private List<DefaultElement> elements = new ArrayList<DefaultElement>();
    private List<BasicAttribute> attrs = new ArrayList<BasicAttribute>();
    private String xpath = "";
    private NGSNode node = null;
    private AttributeType attrType = null;

    public Checker(String xpath, NGSNode node, List<DefaultElement> elements, List<BasicAttribute> attrs) {
        this.xpath = xpath;
        this.node = node;
        this.elements = elements;
        this.attrs = attrs;
    }

    public Checker(String xpath, NGSNode node) {
        this.xpath = xpath;
        this.node = node;
    }

    public Checker(String xpath, NGSNode node, AttributeType attrType) {
        this.xpath = xpath;
        this.node = node;
        this.attrType = attrType;
    }

    public String getXpath() {
        return this.xpath;
    }

    public NGSNode getNode() {
        return this.node;
    }

    public AttributeType getAttrType() {
        return this.attrType;
    }

    public boolean isAttr() {
        return this.attrType != null;
    }

    public boolean hasAttr(String name) {
        if (this.isAttr()) {
            return false;
        }
        for (BasicAttribute ba : this.attrs) {
            if (!ba.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasElement(String name) {
        if (this.isAttr()) {
            return false;
        }
        for (DefaultElement de : this.elements) {
            if (!de.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String[] listAttrs() {
        String[] array = new String[this.attrs.size()];
        int i = 0;
        for (BasicAttribute ba : this.attrs) {
            array[i] = ba.getName();
            ++i;
        }
        return array;
    }

    public String[] listElements() {
        String[] array = new String[this.elements.size()];
        int i = 0;
        for (DefaultElement de : this.elements) {
            array[i] = de.getName();
            ++i;
        }
        return array;
    }

    public boolean isAttrValid(String name, String value) {
        if (this.isAttr()) {
            return false;
        }
        for (BasicAttribute ba : this.attrs) {
            if (!ba.getName().equals(name)) continue;
            return ba.getValueType().isValid(value);
        }
        return false;
    }
}

