/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsmllib.node;

import cn.edu.suda.ngsmllib.node.NGSElement;
import cn.edu.suda.ngsmllib.node.NGSNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class BasicElement
implements NGSElement {
    String name;
    int max = 1;
    int min = 1;
    boolean text = false;
    int seqno = -1;
    NGSNode parent = null;
    List<NGSNode> children = new ArrayList<NGSNode>();

    public BasicElement(String name) {
        this.name = name;
    }

    public BasicElement(String name, NGSElement parent) {
        this.name = name;
        this.parent = parent;
    }

    @Override
    public int getMaxCount() {
        return this.max;
    }

    @Override
    public void setMaxCount(int max) {
        this.max = max;
    }

    @Override
    public int getMinCount() {
        return this.min;
    }

    @Override
    public void setMinCount(int min) {
        this.min = min;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public NGSNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(NGSNode parent) {
        this.parent = parent;
    }

    @Override
    public NGSNode getChild(int index) {
        return this.children.get(index);
    }

    @Override
    public void addChild(NGSNode child) {
        this.children.add(child);
    }

    @Override
    public int getSeqno() {
        return this.seqno;
    }

    @Override
    public void setSeqno(int seqno) {
        this.seqno = seqno;
    }

    @Override
    public boolean isText() {
        return this.text;
    }

    @Override
    public void setText(boolean text) {
        this.text = text;
    }

    @Override
    public boolean hasChild(NGSElement e) {
        for (NGSNode child : this.children) {
            if (!(child instanceof NGSElement) || !child.equals(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicElement other = (BasicElement)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        return Objects.equals(this.children, other.children);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.name);
        hash = 71 * hash + Objects.hashCode(this.children);
        return hash;
    }
}

