/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core;

import cn.edu.suda.ngsml.core.DataType;
import cn.edu.suda.ngsml.core.XMLData;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class Parser {
    private Parser() {
    }

    public static DefaultMutableTreeNode parseDocToNode(Document doc) {
        Element root = doc.getRootElement();
        DefaultMutableTreeNode r = new DefaultMutableTreeNode(new XMLData(root.getQName().getName(), "", DataType.Element, "/ngs"));
        XMLData xmlns = new XMLData("xmlns", "http://www.sysbio.org.cn/ngsml/version1", DataType.Namespace, "");
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(xmlns);
        r.add(child);
        return Parser.parseElement(root, r);
    }

    public static Document parseNodeToDoc(DefaultMutableTreeNode root) {
        Element e = Parser.parseToElement(root, null);
        Document doc = DocumentFactory.getInstance().createDocument(e);
        return doc;
    }

    private static DefaultMutableTreeNode parseElement(Element e, DefaultMutableTreeNode parent) {
        Parser.parseAttr(e, parent);
        List<Element> eles = e.elements();
        Iterator<Element> iterator = eles.iterator();
        while (iterator.hasNext()) {
            Element obj;
            Element ele = obj = iterator.next();
            XMLData data = new XMLData(ele.getQName().getName(), ele.getTextTrim(), DataType.Element, Parser.detachNamespace(ele.getPath()));
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(data);
            parent.add(child);
            Parser.parseElement(ele, child);
        }
        return parent;
    }

    private static void parseAttr(Element e, DefaultMutableTreeNode parent) {
        List<Attribute> attrs = e.attributes();
        for (Attribute obj : attrs) {
            DefaultMutableTreeNode child;
            Attribute attr = obj;
            if (attr.getName().equals("schemaLocation")) {
                XMLData xsi = new XMLData("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", DataType.Attribute, Parser.detachNamespace(attr.getPath()));
                child = new DefaultMutableTreeNode(xsi);
                parent.add(child);
                XMLData schemaLocation = new XMLData("xsi:schemaLocation", attr.getValue(), DataType.Attribute, Parser.detachNamespace(attr.getPath()));
                child = new DefaultMutableTreeNode(schemaLocation);
                parent.add(child);
                continue;
            }
            XMLData data = new XMLData(attr.getQName().getName(), attr.getValue(), DataType.Attribute, Parser.detachNamespace(attr.getPath()));
            child = new DefaultMutableTreeNode(data);
            parent.add(child);
        }
    }

    private static String detachNamespace(String xpath) {
        return xpath.replaceAll("/\\*\\[name\\(\\)='(\\w*)'\\]", "/$1");
    }

    private static Element parseToElement(DefaultMutableTreeNode node, Element parent) {
        XMLData data = (XMLData)node.getUserObject();
        if (data.getType() == DataType.Element) {
            String name = data.getName();
            Element e = DocumentHelper.createElement(new QName(name, Namespace.get("http://www.sysbio.org.cn/ngsml/version1")));
            if (!data.getValue().trim().isEmpty()) {
                e.setText(data.getValue());
            }
            if (parent != null) {
                parent.add(e);
            } else {
                parent = e;
            }
            if (!node.isLeaf()) {
                Enumeration<TreeNode> enu = node.children();
                while (enu.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)enu.nextElement();
                    Parser.parseToElement(n, e);
                }
            }
        } else if (data.getType() == DataType.Attribute) {
            String name = data.getName();
            parent.addAttribute(name, data.getValue());
        }
        return parent;
    }
}

