/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.FastaConverter;
import cn.edu.suda.ngsml.core.conversion.FastqConverter;
import cn.edu.suda.ngsml.core.conversion.GFF3Converter;
import cn.edu.suda.ngsml.core.conversion.SAMConverter;

public class ConvertFactory {
    private static final ConvertFactory INSTANCE = new ConvertFactory();

    private ConvertFactory() {
    }

    public static ConvertFactory getInstance() {
        return INSTANCE;
    }

    public Converter getConverter(Converter.FileType type) {
        switch (type) {
            case FASTA: {
                return new FastaConverter();
            }
            case FASTQ: {
                return new FastqConverter();
            }
            case SAM: {
                return new SAMConverter();
            }
            case GFF3: {
                return new GFF3Converter();
            }
        }
        return null;
    }
}

