/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.AbstractConverter;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.FastaFile;
import cn.edu.suda.ngsml.core.conversion.FastqFile;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsmllib.CheckFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FastaConverter
extends AbstractConverter<FastaFile> {
    public FastaConverter() {
        super(Converter.FileType.FASTA);
    }

    @Override
    public NGSFile convert(Document doc) throws NGSException {
        Attribute refFileType = doc.getRootElement().attribute("refFileType");
        String refFileTypeValue = refFileType.getValue();
        if (!refFileTypeValue.equals("FASTA")) {
            throw new NGSException("The NGSML file missing attribute: refFileType=\"FASTA\"!");
        }
        List<Node> list = doc.selectNodes("*[name()='list_of_seqs']/*[name()='seq']");
        FastaFile ff = new FastaFile();
        for (Node obj : list) {
            if (!(obj instanceof Element)) continue;
            Element e = (Element)obj;
            String nid = e.attributeValue("nid");
            if (nid == null) {
                throw new NGSException("Missing attribute in element seq: nid!");
            }
            Element annotation = e.element("annotation");
            String s = annotation.getText();
            if (s.isEmpty()) {
                s = nid;
            }
            String seq = null;
            try {
                seq = this.getSeq(e);
            }
            catch (Exception ex) {
                throw new NGSException(ex.getMessage());
            }
            if (seq == null || seq.isEmpty()) continue;
            ff.addSeq(s, seq);
        }
        return ff;
    }

    @Override
    public NGSFile convert(String file) throws NGSException {
        final FastaFile ff = new FastaFile();
        SAXReader saxReader = new SAXReader();
        saxReader.addHandler("/ngs/list_of_seqs/seq", new ElementHandler(){

            @Override
            public void onEnd(ElementPath elem) {
                try {
                    Element seqNode = elem.getCurrent();
                    Element annotation = seqNode.element("annotation");
                    String s = annotation.getText();
                    String seq = FastaConverter.this.getSeq(seqNode);
                    if (seq != null && !seq.isEmpty()) {
                        ff.addSeq(s, seq);
                    }
                    seqNode.detach();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void onStart(ElementPath elem) {
            }
        });
        try {
            saxReader.read(new File(file));
        }
        catch (Exception ex) {
            throw new NGSException(ex.toString());
        }
        return ff;
    }

    @Override
    public int convert(String ngsml_file, String ngs_file) throws NGSException {
        return 1;
    }

    @Override
    public Document convert(FastaFile file) throws NGSException {
        Document doc = CheckFactory.getInstance().buildNew();
        Element ngsElement = doc.getRootElement();
        ngsElement.addAttribute("refFileType", "FASTA");
        Element e = doc.getRootElement().addElement("list_of_seqs");
        this.resetSequentialNumber();
        for (FastaFile.FastaSeq fs : file.getSeqs()) {
            Element seq = e.addElement("seq");
            seq.addAttribute("nid", this.getUniqueNid(doc));
            Element annotation = seq.addElement("annotation");
            annotation.setText(fs.getDes());
            Element origin = seq.addElement("origin");
            origin.setText(fs.getSeq());
        }
        return doc;
    }

    @Override
    public int convert(FastaFile file, String output_file) throws NGSException {
        return 1;
    }

    private String getSeq(Element e) throws NGSException, IOException, Exception {
        Element origin = e.element("origin");
        Element file = e.element("file");
        if (origin != null) {
            return origin.getText();
        }
        if (file != null) {
            String no;
            String path = file.attributeValue("path");
            if (path == null) {
                throw new NGSException("Missing attribute in element file: path!");
            }
            String filetype = file.attributeValue("filetype");
            if (filetype == null) {
                filetype = "fasta";
            }
            if ((no = file.attributeValue("no")) == null) {
                no = "1";
            }
            switch (filetype) {
                case "fasta": {
                    FastaFile f1 = (FastaFile)new FastaFile().read(path);
                    return f1.getSeqAt(Integer.parseInt(no) - 1);
                }
                case "fastq": {
                    FastqFile f2 = (FastqFile)new FastqFile().read(path);
                    return f2.getSeqAt(Integer.parseInt(no) - 1);
                }
            }
            throw new NGSException("Unknow file type!");
        }
        throw new NGSException("Missing Element: origin or file!");
    }
}

