/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.AbstractNGSFile;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FastaFile
extends AbstractNGSFile {
    private List<FastaSeq> seqs = new ArrayList<FastaSeq>();

    public FastaFile() {
        super(Converter.FileType.FASTA, true);
    }

    List<FastaSeq> getSeqs() {
        return this.seqs;
    }

    public int getSeqCount() {
        return this.seqs.size();
    }

    public String getSeqAt(int index) {
        if (index >= this.seqs.size()) {
            return "";
        }
        return this.seqs.get(index).seq;
    }

    public String getDesAt(int index) {
        if (index >= this.seqs.size()) {
            return "";
        }
        return this.seqs.get(index).des;
    }

    public void addSeq(String des, String seq) {
        this.seqs.add(new FastaSeq(des, seq));
    }

    @Override
    public NGSFile read(String file) throws IOException {
        FastaSeq fa;
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        String des = null;
        StringBuilder seq = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if (line.isEmpty()) continue;
            if (line.startsWith(">")) {
                if (des != null) {
                    fa = new FastaSeq(des, seq.toString());
                    this.seqs.add(fa);
                    des = null;
                    seq = new StringBuilder();
                }
                if (line.length() > 1) {
                    des = line.substring(1);
                    continue;
                }
                des = "";
                continue;
            }
            if ((line = line.trim()).isEmpty()) continue;
            if (seq.length() > 0) {
                seq.append(System.getProperty("line.separator"));
            }
            seq.append(line);
        }
        if (des != null) {
            fa = new FastaSeq(des, seq.toString());
            this.seqs.add(fa);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.seqs.size(); ++i) {
            FastaSeq sq = this.seqs.get(i);
            sb.append(sq.toString());
            if (i == this.seqs.size() - 1) continue;
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    class FastaSeq {
        private String des;
        private String seq;

        FastaSeq(String des, String seq) {
            this.des = des;
            this.seq = seq;
        }

        public String getDes() {
            return this.des;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public String getSeq() {
            this.seq = this.seq.replaceAll("[\\t\\r\\n]", "");
            return this.seq;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public String toString() {
            return ">" + this.des + System.getProperty("line.separator") + this.seq;
        }
    }
}

