/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.AbstractConverter;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.FastaFile;
import cn.edu.suda.ngsml.core.conversion.FastqFile;
import cn.edu.suda.ngsml.core.conversion.FastqSAXHandler;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsmllib.CheckFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FastqConverter
extends AbstractConverter<FastqFile> {
    public FastqConverter() {
        super(Converter.FileType.FASTQ);
    }

    @Override
    public Document convert(FastqFile file) throws NGSException {
        Document doc = CheckFactory.getInstance().buildNew();
        Element ngsElement = doc.getRootElement();
        ngsElement.addAttribute("refFileType", "FASTQ");
        Element seqs = doc.getRootElement().addElement("list_of_seqs");
        Element quals = doc.getRootElement().addElement("list_of_quals");
        Element seqinfos = doc.getRootElement().addElement("list_of_seqinfos");
        this.resetSequentialNumber();
        for (FastqFile.FastqSeq fs : file.getSeqs()) {
            Element seq = seqs.addElement("seq");
            String seqnid = this.getUniqueNid(doc);
            seq.addAttribute("nid", seqnid);
            Element annotation = seq.addElement("annotation");
            annotation.setText(fs.getDes());
            Element origin = seq.addElement("origin");
            origin.setText(fs.getSeq());
            Element qual = quals.addElement("qual");
            String qualnid = this.getUniqueNid(doc);
            qual.addAttribute("nid", qualnid);
            Element origin2 = qual.addElement("origin");
            origin2.setText(fs.getQual());
            Element seqinfo = seqinfos.addElement("seqinfo");
            seqinfo.addAttribute("nid", this.getUniqueNid(doc));
            Element s = seqinfo.addElement("seq");
            s.addAttribute("seqref", seqnid);
            Element q = seqinfo.addElement("qual");
            q.addAttribute("qualref", qualnid);
        }
        return doc;
    }

    @Override
    public int convert(FastqFile file, String output_file) throws NGSException {
        SAXTransformerFactory tff = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler handler = tff.newTransformerHandler();
            Transformer tr = handler.getTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "yes");
            File f = new File(output_file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            StreamResult result = new StreamResult(fos);
            handler.setResult(result);
            handler.startDocument();
            AttributesImpl attr = new AttributesImpl();
            attr.clear();
            attr.addAttribute("", "", "xmlns", "", "http://www.sysbio.org.cn/ngsml/version1");
            attr.addAttribute("", "", "version", "", "2.0");
            attr.addAttribute("", "", "xmlns:xsi", "", "http://www.w3.org/2001/XMLSchema-instance");
            attr.addAttribute("", "", "xsi:schemaLocation", "", "http://www.sysbio.org.cn/ngsml/version1 http://www.sysbio.org.cn/ngsml/ngsml.xsd");
            attr.addAttribute("", "", "refFileType", "", "FASTQ");
            handler.startElement("", "", "ngs", attr);
            attr.clear();
            handler.startElement("", "", "list_of_seqs", attr);
            this.resetSequentialNumber();
            String nid = "";
            for (String[] gs : file.getSeqsArray()) {
                nid = this.getUniqueNid(null);
                attr.clear();
                attr.addAttribute("", "", "nid", "", nid);
                handler.startElement("", "", "seq", attr);
                attr.clear();
                handler.startElement("", "", "annotation", attr);
                handler.characters(gs[0].toCharArray(), 1, gs[0].length() - 1);
                handler.endElement("", "", "annotation");
                handler.startElement("", "", "origin", attr);
                handler.characters(gs[1].toCharArray(), 0, gs[1].length());
                handler.endElement("", "", "origin");
                handler.endElement("", "", "seq");
            }
            handler.endElement("", "", "list_of_seqs");
            attr.clear();
            handler.startElement("", "", "list_of_quals", attr);
            this.resetSequentialNumber();
            for (String[] gs : file.getSeqsArray()) {
                nid = this.getUniqueQualNid(null);
                attr.clear();
                attr.addAttribute("", "", "nid", "", nid);
                handler.startElement("", "", "qual", attr);
                attr.clear();
                handler.startElement("", "", "origin", attr);
                handler.characters(gs[3].toCharArray(), 0, gs[3].length());
                handler.endElement("", "", "origin");
                handler.endElement("", "", "qual");
            }
            handler.endElement("", "", "list_of_quals");
            attr.clear();
            handler.startElement("", "", "list_of_seqinfos", attr);
            this.resetSequentialNumber();
            int count = 1;
            for (String[] gs : file.getSeqsArray()) {
                attr.clear();
                attr.addAttribute("", "", "nid", "", this.getUniqueSeqinfoNid(null));
                handler.startElement("", "", "seqinfo", attr);
                attr.clear();
                attr.addAttribute("", "", "seqref", "", "s" + String.valueOf(count));
                handler.startElement("", "", "seq", attr);
                handler.endElement("", "", "seq");
                attr.clear();
                attr.addAttribute("", "", "qualref", "", "q" + String.valueOf(count));
                handler.startElement("", "", "qual", attr);
                handler.endElement("", "", "qual");
                handler.endElement("", "", "seqinfo");
                ++count;
            }
            handler.endElement("", "", "list_of_seqinfos");
            handler.endElement("", "", "ngs");
            handler.endDocument();
            fos.flush();
            fos.close();
            return 1;
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return -1;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public NGSFile convert(Document doc) throws NGSException {
        Object seq;
        Attribute refFileType = doc.getRootElement().attribute("refFileType");
        String refFileTypeValue = refFileType.getValue();
        if (!refFileTypeValue.equals("FASTQ")) {
            throw new NGSException("The NGSML file missing attribute: refFileType=\"FASTQ\"!");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSeqName = new HashMap<String, String>();
        List<Node> listseq = doc.getRootElement().selectNodes("*[name()='list_of_seqs']/*[name()='seq']");
        FastqFile ff = new FastqFile();
        for (Node node : listseq) {
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String nid = element.attributeValue("nid");
            if (nid == null) {
                throw new NGSException("Missing Attribute: nid!");
            }
            String annotation = "";
            Element annotationElement = element.element("annotation");
            annotation = annotationElement.getText();
            seq = null;
            try {
                seq = this.getSeq(element);
            }
            catch (IOException ex) {
                throw new NGSException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new NGSException(ex.getMessage());
            }
            if (seq == null || ((String)seq).isEmpty()) continue;
            map.put(nid, (String)seq);
            mapSeqName.put(nid, annotation);
        }
        List<Node> listqual = doc.getRootElement().selectNodes("*[name()='list_of_quals']/*[name()='qual']");
        for (Node node : listqual) {
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            String nid = e.attributeValue("nid");
            if (nid == null) {
                throw new NGSException("Missing Attribute: nid!");
            }
            String annotation = "";
            Element annotationElement = e.element("annotation");
            if (annotationElement != null) {
                annotation = annotationElement.getText();
            }
            String qual = null;
            try {
                qual = this.getQual(e);
            }
            catch (IOException ex) {
                throw new NGSException(ex.getMessage());
            }
            catch (Exception ex) {
                throw new NGSException(ex.getMessage());
            }
            if (qual == null || qual.isEmpty()) continue;
            map.put(nid, qual);
            mapSeqName.put(nid, annotation);
        }
        List<Node> list = doc.getRootElement().selectNodes("*[name()='list_of_seqinfos']/*[name()='seqinfo']");
        for (Node obj : list) {
            if (!(obj instanceof Element)) continue;
            Element e = (Element)obj;
            String nid = e.attributeValue("nid");
            if (nid == null) {
                throw new NGSException("Missing Attribute: nid!");
            }
            seq = e.element("seq");
            if (seq == null) {
                throw new NGSException("Missing Element: seq!");
            }
            String seqref = seq.attributeValue("seqref");
            if (seqref == null || seqref.isEmpty()) {
                throw new NGSException("Missing Attribute: seqref!");
            }
            Element qual = e.element("qual");
            if (qual == null) {
                throw new NGSException("Missing Element: qual!");
            }
            String qualref = qual.attributeValue("qualref");
            if (qualref == null || qualref.isEmpty()) {
                throw new NGSException("Missing Attribute: qualref!");
            }
            String fqname = (String)mapSeqName.get(seqref);
            String fqseq = (String)map.get(seqref);
            String fqqual = (String)map.get(qualref);
            if (fqseq == null || fqqual == null) continue;
            ff.addSeq(fqname, fqseq, fqqual);
        }
        return ff;
    }

    @Override
    public NGSFile convert(String file) throws NGSException {
        FastqFile ff = new FastqFile();
        SAXReader saxReader = new SAXReader();
        try {
            FastqSAXHandler fastqElementHandler = new FastqSAXHandler(ff);
            saxReader.addHandler("/ngs/list_of_seqs/seq", fastqElementHandler);
            saxReader.addHandler("/ngs/list_of_quals/qual", fastqElementHandler);
            saxReader.addHandler("/ngs/list_of_seqinfos/seqinfo", fastqElementHandler);
            saxReader.read(new File(file));
        }
        catch (UnsupportedOperationException | DocumentException ex) {
            throw new NGSException(ex.toString());
        }
        return ff;
    }

    @Override
    public int convert(String ngsml_file, String ngs_file) throws NGSException {
        try {
            final FileWriter fw = new FileWriter(ngs_file);
            SAXReader saxReader = new SAXReader();
            final HashMap annotationMap = new HashMap();
            final HashMap originMap = new HashMap();
            final HashMap qualMap = new HashMap();
            saxReader.addHandler("/ngs/list_of_seqs/seq", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    Element seqNode = elem.getCurrent();
                    String nid = seqNode.attributeValue("nid");
                    Element annotation = seqNode.element("annotation");
                    if (annotation != null) {
                        String a_text = annotation.getText();
                        if (!annotationMap.containsKey(nid)) {
                            annotationMap.put(nid, a_text);
                        }
                    }
                    Element origin = seqNode.element("origin");
                    String o_text = origin.getText();
                    if (!originMap.containsKey(nid)) {
                        originMap.put(nid, o_text);
                    }
                    seqNode.detach();
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.addHandler("/ngs/list_of_quals/qual", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    Element qualNode = elem.getCurrent();
                    String nid = qualNode.attributeValue("nid");
                    Element origin = qualNode.element("origin");
                    String s = origin.getText();
                    if (!qualMap.containsKey(nid)) {
                        qualMap.put(nid, s);
                    }
                    qualNode.detach();
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.addHandler("/ngs/list_of_seqinfos/seqinfo", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    Element qual;
                    String seq_value = "";
                    String anno_value = "";
                    String qual_value = "";
                    Element seqNode = elem.getCurrent();
                    Element seq = seqNode.element("seq");
                    String nid = seq.attributeValue("seqref");
                    if (originMap.containsKey(nid)) {
                        seq_value = (String)originMap.get(nid);
                    }
                    if (annotationMap.containsKey(nid)) {
                        anno_value = (String)annotationMap.get(nid);
                    }
                    if (qualMap.containsKey(nid = (qual = seqNode.element("qual")).attributeValue("qualref"))) {
                        qual_value = (String)qualMap.get(nid);
                    }
                    try {
                        fw.append("@" + anno_value + System.getProperty("line.separator") + seq_value + System.getProperty("line.separator") + "+" + System.getProperty("line.separator") + qual_value + System.getProperty("line.separator"));
                    }
                    catch (IOException ex) {
                        System.out.println(ex.toString());
                    }
                    seqNode.detach();
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.read(new File(ngsml_file));
            fw.flush();
            fw.close();
            return 1;
        }
        catch (DocumentException ex) {
            throw new NGSException(ex.toString());
        }
        catch (IOException ex) {
            throw new NGSException(ex.toString());
        }
        catch (Exception ex) {
            throw new NGSException(ex.toString());
        }
    }

    private String getSeq(Element e) throws NGSException, IOException, Exception {
        Element origin = e.element("origin");
        Element file = e.element("file");
        if (origin != null) {
            return origin.getText();
        }
        if (file != null) {
            String no;
            String path = file.attributeValue("path");
            if (path == null) {
                throw new NGSException("Missing Attribute: path!");
            }
            String filetype = file.attributeValue("filetype");
            if (filetype == null) {
                filetype = "fasta";
            }
            if ((no = file.attributeValue("no")) == null) {
                no = "1";
            }
            switch (filetype) {
                case "fasta": {
                    FastaFile f1 = (FastaFile)new FastaFile().read(path);
                    return f1.getSeqAt(Integer.parseInt(no) - 1);
                }
                case "fastq": {
                    FastqFile f2 = (FastqFile)new FastqFile().read(path);
                    return f2.getSeqAt(Integer.parseInt(no) - 1);
                }
            }
            throw new NGSException("Unknow file type!");
        }
        throw new NGSException("Missing Element: origin or file!");
    }

    private String getQual(Element e) throws NGSException, IOException, Exception {
        Element origin = e.element("origin");
        Element file = e.element("file");
        if (origin != null) {
            String qual = origin.getText();
            qual = qual.replace("&amp;", "&");
            qual = qual.replace("&gt;", ">");
            qual = qual.replace("&lt;", "<");
            return qual;
        }
        if (file != null) {
            String no;
            String path = file.attributeValue("path");
            if (path == null) {
                throw new NGSException("Missing Attribute: path!");
            }
            String filetype = file.attributeValue("filetype");
            if (filetype == null) {
                filetype = "qual";
            }
            if ((no = file.attributeValue("no")) == null) {
                no = "1";
            }
            switch (filetype) {
                case "qual": {
                    FastaFile f1 = (FastaFile)new FastaFile().read(path);
                    return f1.getSeqAt(Integer.parseInt(no) - 1);
                }
                case "fastq": {
                    FastqFile f2 = (FastqFile)new FastqFile().read(path);
                    return f2.getQualAt(Integer.parseInt(no) - 1);
                }
            }
            throw new NGSException("Unknow file type!");
        }
        throw new NGSException("Missing Element: origin or file!");
    }
}

