/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.AbstractNGSFile;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.util.FileHelper;
import java.util.ArrayList;
import java.util.List;

public class FastqFile
extends AbstractNGSFile {
    private List<FastqSeq> seqs = new ArrayList<FastqSeq>();
    public ArrayList<String[]> seq_lines = new ArrayList();

    public FastqFile() {
        super(Converter.FileType.FASTA, true);
    }

    List<FastqSeq> getSeqs() {
        return this.seqs;
    }

    ArrayList<String[]> getSeqsArray() {
        return this.seq_lines;
    }

    public int getSeqCount() {
        return this.seqs.size();
    }

    public String getSeqAt(int index) {
        if (index >= this.seqs.size()) {
            return "";
        }
        return this.seqs.get((int)index).seq;
    }

    public String getDesAt(int index) {
        if (index >= this.seqs.size()) {
            return "";
        }
        return this.seqs.get((int)index).des;
    }

    public String getQualAt(int index) {
        if (index >= this.seqs.size()) {
            return "";
        }
        return this.seqs.get((int)index).qual;
    }

    public void addSeq(String des, String seq, String qual) {
        this.seqs.add(new FastqSeq(des, seq, qual));
    }

    @Override
    public NGSFile read(String file) throws Exception {
        String des = "";
        String seq = "";
        String des1 = "";
        String qual = "";
        String fileContent = FileHelper.read(file);
        if (fileContent == null) {
            return null;
        }
        fileContent = fileContent.replaceAll("(\\r)?\\n", "\n");
        String[] separated = fileContent.split("\n");
        this.seq_lines.clear();
        int lineOrder = 1;
        block6: for (String line : separated) {
            if (line.isEmpty()) continue;
            switch (lineOrder) {
                case 1: {
                    des = line;
                    lineOrder = 2;
                    continue block6;
                }
                case 2: {
                    seq = line;
                    lineOrder = 3;
                    continue block6;
                }
                case 3: {
                    des1 = line;
                    lineOrder = 4;
                    continue block6;
                }
                case 4: {
                    qual = line;
                    String[] seq_line = new String[]{des, seq, des1, qual};
                    this.seq_lines.add(seq_line);
                    lineOrder = 1;
                }
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.seqs.size(); ++i) {
            FastqSeq sq = this.seqs.get(i);
            sb.append(sq.toString());
            if (i == this.seqs.size() - 1) continue;
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    class FastqSeq {
        String des;
        String seq;
        String qual;

        public FastqSeq(String des, String seq, String qual) {
            this.des = des;
            this.seq = seq;
            this.qual = qual;
        }

        public String getDes() {
            return this.des;
        }

        public String getSeq() {
            return this.seq;
        }

        public String getQual() {
            return this.qual;
        }

        public void setDes(String des) {
            this.des = des;
        }

        public void setSeq(String seq) {
            this.seq = seq;
        }

        public void setQual(String qual) {
            this.qual = qual;
        }

        public String toString() {
            return "@" + this.des + System.getProperty("line.separator") + this.seq + System.getProperty("line.separator") + "+" + System.getProperty("line.separator") + this.qual;
        }
    }
}

