/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.FastaFile;
import cn.edu.suda.ngsml.core.conversion.FastqFile;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

public class FastqSAXHandler
implements ElementHandler {
    Map<String, String> seqValue = null;
    Map<String, String> seqName = null;
    Map<String, String> qualValue = null;
    FastqFile ff = null;

    public FastqFile getFastqFile() {
        return this.ff;
    }

    public FastqSAXHandler(FastqFile fq) {
        this.ff = fq;
        this.seqValue = new HashMap<String, String>();
        this.seqName = new HashMap<String, String>();
        this.qualValue = new HashMap<String, String>();
    }

    @Override
    public void onStart(ElementPath ep) {
    }

    @Override
    public void onEnd(ElementPath ep) {
        Element node = ep.getCurrent();
        String nodePath = ep.getPath();
        try {
            if (nodePath.equals("/ngs/list_of_seqs/seq")) {
                String nid = node.attributeValue("nid");
                String annotation = node.elementText("annotation");
                String seq = node.elementText("origin");
                this.seqName.put(nid, annotation);
                this.seqValue.put(nid, seq);
            } else if (nodePath.equals("/ngs/list_of_quals/qual")) {
                String nid = node.attributeValue("nid");
                String qual = node.elementText("origin");
                this.qualValue.put(nid, qual);
            } else if (nodePath.equals("/ngs/list_of_seqinfos/seqinfo")) {
                Element seq = node.element("seq");
                String seqref = seq.attributeValue("seqref");
                Element qual = node.element("qual");
                String qualref = qual.attributeValue("qualref");
                String fqname = this.seqName.get(seqref);
                String fqseq = this.seqValue.get(seqref);
                String fqqual = this.qualValue.get(qualref);
                if (fqseq != null && fqqual != null) {
                    this.ff.addSeq(fqname, fqseq, fqqual);
                }
            }
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException(ex.toString());
        }
        node.detach();
    }

    private String getSeq(Element e) throws UnsupportedOperationException, Exception {
        Element origin = e.element("origin");
        Element file = e.element("file");
        if (origin != null) {
            return origin.getText();
        }
        if (file != null) {
            String no;
            String path = file.attributeValue("path");
            if (path == null) {
                throw new UnsupportedOperationException("Missing Attribute: path!");
            }
            String filetype = file.attributeValue("filetype");
            if (filetype == null) {
                filetype = "fasta";
            }
            if ((no = file.attributeValue("no")) == null) {
                no = "1";
            }
            switch (filetype) {
                case "fasta": {
                    try {
                        FastaFile f1 = (FastaFile)new FastaFile().read(path);
                        return f1.getSeqAt(Integer.parseInt(no) - 1);
                    }
                    catch (IOException ex) {
                        throw new UnsupportedOperationException(ex);
                    }
                }
                case "fastq": {
                    try {
                        FastqFile f2 = (FastqFile)new FastqFile().read(path);
                        return f2.getSeqAt(Integer.parseInt(no) - 1);
                    }
                    catch (IOException ex) {
                        throw new UnsupportedOperationException(ex);
                    }
                }
            }
            throw new UnsupportedOperationException("Unknow file type!");
        }
        throw new UnsupportedOperationException("Missing Element: origin or file!");
    }

    private String getQual(Element e) throws UnsupportedOperationException, Exception {
        Element origin = e.element("origin");
        Element file = e.element("file");
        if (origin != null) {
            String qual = origin.getText();
            qual = qual.replace("&amp;", "&");
            qual = qual.replace("&gt;", ">");
            qual = qual.replace("&lt;", "<");
            return qual;
        }
        if (file != null) {
            String no;
            String path = file.attributeValue("path");
            if (path == null) {
                throw new UnsupportedOperationException("Missing Attribute: path!");
            }
            String filetype = file.attributeValue("filetype");
            if (filetype == null) {
                filetype = "qual";
            }
            if ((no = file.attributeValue("no")) == null) {
                no = "1";
            }
            switch (filetype) {
                case "qual": {
                    try {
                        FastaFile f1 = (FastaFile)new FastaFile().read(path);
                        return f1.getSeqAt(Integer.parseInt(no) - 1);
                    }
                    catch (IOException ex) {
                        throw new UnsupportedOperationException(ex);
                    }
                }
                case "fastq": {
                    try {
                        FastqFile f2 = (FastqFile)new FastqFile().read(path);
                        return f2.getQualAt(Integer.parseInt(no) - 1);
                    }
                    catch (IOException ex) {
                        throw new UnsupportedOperationException(ex);
                    }
                }
            }
            throw new UnsupportedOperationException("Unknow file type!");
        }
        throw new UnsupportedOperationException("Missing Element: origin or file!");
    }
}

