/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.AbstractConverter;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.GFF3File;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsmllib.CheckFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GFF3Converter
extends AbstractConverter<GFF3File> {
    public GFF3Converter() {
        super(Converter.FileType.GFF3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NGSFile convert(Document doc) throws NGSException {
        Attribute refFileType = doc.getRootElement().attribute("refFileType");
        String refFileTypeValue = refFileType.getValue();
        if (!refFileTypeValue.equals("GFF3")) {
            throw new NGSException("The NGSML file missing attribute: refFileType=\"GFF3\"!");
        }
        GFF3File gff3 = new GFF3File();
        List<Node> list = doc.selectNodes("*[name()='header_lines']/*[name()='meta_info']");
        for (Node obj : list) {
            void var9_9;
            String commentTag;
            String value;
            if (!(obj instanceof Element)) continue;
            Element e = (Element)obj;
            String string = e.attributeValue("name");
            if (string == null) {
                String string2 = "";
            }
            if ((value = e.attributeValue("value")) == null) {
                value = "";
            }
            if ((commentTag = e.attributeValue("commentTag")) == null) {
                commentTag = "";
            }
            gff3.addHead(commentTag, (String)var9_9, value);
        }
        List<Node> list_seq = doc.selectNodes("*[name()='list_of_seqs']/*[name()='seq']");
        HashMap<String, String> seq = new HashMap<String, String>();
        for (Object e : list_seq) {
            if (!(e instanceof Element)) continue;
            Element e2 = (Element)e;
            String nid = e2.attributeValue("nid");
            Element origin = e2.element("origin");
            String s = origin.getText();
            seq.put(nid, s);
        }
        List<Node> list_seqinfo = doc.selectNodes("*[name()='list_of_seqinfos']/*[name()='seqinfo']");
        for (Node obj : list_seqinfo) {
            if (!(obj instanceof Element)) continue;
            String seqid = "";
            String source = "";
            String type = "";
            String start = "";
            String end = "";
            String score = "";
            String strand = "";
            String phase = "";
            String attributes = "";
            Element e = (Element)obj;
            Element seqinfo_seq = e.element("seq");
            String s = seqinfo_seq.attributeValue("seqref");
            seqid = (String)seq.get(s);
            List<Element> readFeatures = e.elements("feature");
            for (Element objFeature : readFeatures) {
                if (!(objFeature instanceof Element)) continue;
                Element f = objFeature;
                String fname = f.attributeValue("name");
                String fvalue = f.attributeValue("value");
                switch (fname) {
                    case "source": {
                        source = fvalue;
                        break;
                    }
                    case "type": {
                        type = fvalue;
                        break;
                    }
                    case "start": {
                        start = fvalue;
                        break;
                    }
                    case "end": {
                        end = fvalue;
                        break;
                    }
                    case "score": {
                        score = fvalue;
                        break;
                    }
                    case "strand": {
                        strand = fvalue;
                        break;
                    }
                    case "phase": {
                        phase = fvalue;
                        break;
                    }
                    case "attributes": {
                        attributes = fvalue;
                        break;
                    }
                }
            }
            gff3.addSeq(seqid, source, type, start, end, score, strand, phase, attributes);
        }
        return gff3;
    }

    @Override
    public NGSFile convert(String ngsml_file) throws NGSException {
        return null;
    }

    @Override
    public int convert(String ngsml_file, String ngs_file) throws NGSException {
        try {
            final FileWriter fw = new FileWriter(ngs_file);
            SAXReader saxReader = new SAXReader();
            final HashMap seqidMap = new HashMap();
            saxReader.addHandler("/ngs/header_lines/meta_info", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    Element seqNode = elem.getCurrent();
                    String name = seqNode.attributeValue("name");
                    String value = seqNode.attributeValue("value");
                    String commentTag = seqNode.attributeValue("commentTag");
                    seqNode.detach();
                    try {
                        fw.append(commentTag + name + " " + value + System.getProperty("line.separator"));
                    }
                    catch (IOException ex) {
                        System.out.println(ex.toString());
                    }
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.addHandler("/ngs/list_of_seqs/seq", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    Element seqNode = elem.getCurrent();
                    String nid = seqNode.attributeValue("nid");
                    Element origin = seqNode.element("origin");
                    String s = origin.getText();
                    if (!seqidMap.containsValue(s)) {
                        seqidMap.put(nid, s);
                    }
                    seqNode.detach();
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.addHandler("/ngs/list_of_seqinfos/seqinfo", new ElementHandler(){

                @Override
                public void onEnd(ElementPath elem) {
                    String seqid = "";
                    String source = "";
                    String type = "";
                    String start = "";
                    String end = "";
                    String score = "";
                    String strand = "";
                    String phase = "";
                    String attributes = "";
                    Element seqNode = elem.getCurrent();
                    Element seq = seqNode.element("seq");
                    String nid = seq.attributeValue("seqref");
                    if (seqidMap.containsKey(nid)) {
                        seqid = (String)seqidMap.get(nid);
                    }
                    String fname = "";
                    String fvalue = "";
                    List<Element> readFeatures = seqNode.elements("feature");
                    for (Element objFeature : readFeatures) {
                        if (!(objFeature instanceof Element)) continue;
                        Element f = objFeature;
                        fname = f.attributeValue("name");
                        fvalue = f.attributeValue("value");
                        switch (fname) {
                            case "source": {
                                source = fvalue;
                                break;
                            }
                            case "type": {
                                type = fvalue;
                                break;
                            }
                            case "start": {
                                start = fvalue;
                                break;
                            }
                            case "end": {
                                end = fvalue;
                                break;
                            }
                            case "score": {
                                score = fvalue;
                                break;
                            }
                            case "strand": {
                                strand = fvalue;
                                break;
                            }
                            case "phase": {
                                phase = fvalue;
                                break;
                            }
                            case "attributes": {
                                attributes = fvalue;
                                break;
                            }
                        }
                    }
                    try {
                        fw.append(seqid + "\t" + source + "\t" + type + "\t" + start + "\t" + end + "\t" + score + "\t" + strand + "\t" + phase + "\t" + attributes + System.getProperty("line.separator"));
                    }
                    catch (IOException ex) {
                        System.out.println(ex.toString());
                    }
                    seqNode.detach();
                }

                @Override
                public void onStart(ElementPath elem) {
                }
            });
            saxReader.read(new File(ngsml_file));
            fw.flush();
            fw.close();
            return 1;
        }
        catch (DocumentException ex) {
            throw new NGSException(ex.toString());
        }
        catch (IOException ex) {
            throw new NGSException(ex.toString());
        }
        catch (Exception ex) {
            throw new NGSException(ex.toString());
        }
    }

    @Override
    public int convert(GFF3File file, String output_file) throws NGSException {
        SAXTransformerFactory tff = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler handler = tff.newTransformerHandler();
            Transformer tr = handler.getTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "yes");
            File f = new File(output_file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            StreamResult result = new StreamResult(fos);
            handler.setResult(result);
            handler.startDocument();
            AttributesImpl attr = new AttributesImpl();
            attr.clear();
            attr.addAttribute("", "", "xmlns", "", "http://www.sysbio.org.cn/ngsml/version1");
            attr.addAttribute("", "", "version", "", "2.0");
            attr.addAttribute("", "", "xmlns:xsi", "", "http://www.w3.org/2001/XMLSchema-instance");
            attr.addAttribute("", "", "xsi:schemaLocation", "", "http://www.sysbio.org.cn/ngsml/version1 http://www.sysbio.org.cn/ngsml/ngsml.xsd");
            attr.addAttribute("", "", "refFileType", "", "GFF3");
            handler.startElement("", "", "ngs", attr);
            if (file.getHeader().size() > 0) {
                attr.clear();
                handler.startElement("", "", "header_lines", attr);
                for (GFF3File.GFF3Header header : file.getHeader()) {
                    String commentTag = header.getCommentTag();
                    String name = header.getName();
                    String value = header.getValue();
                    attr.clear();
                    attr.addAttribute("", "", "name", "", name);
                    attr.addAttribute("", "", "value", "", value);
                    attr.addAttribute("", "", "commentTag", "", commentTag);
                    handler.startElement("", "", "meta_info", attr);
                    handler.endElement("", "", "meta_info");
                }
                handler.endElement("", "", "header_lines");
            }
            attr.clear();
            handler.startElement("", "", "list_of_seqs", attr);
            this.resetSequentialNumber();
            HashMap<String, String> seqidMap = new HashMap<String, String>();
            for (String[] gs : file.getSeqsArray()) {
                String nid = "";
                if (seqidMap.containsKey(gs[0])) continue;
                nid = this.getUniqueNid(null);
                seqidMap.put(gs[0], nid);
                attr.clear();
                attr.addAttribute("", "", "nid", "", nid);
                handler.startElement("", "", "seq", attr);
                attr.clear();
                handler.startElement("", "", "origin", attr);
                handler.characters(gs[0].toCharArray(), 0, gs[0].length());
                handler.endElement("", "", "origin");
                handler.endElement("", "", "seq");
            }
            attr.clear();
            handler.endElement("", "", "list_of_seqs");
            attr.clear();
            handler.startElement("", "", "list_of_seqinfos", attr);
            for (String[] gs : file.getSeqsArray()) {
                attr.clear();
                attr.addAttribute("", "", "nid", "", this.getUniqueSeqinfoNid(null));
                handler.startElement("", "", "seqinfo", attr);
                attr.clear();
                attr.addAttribute("", "", "seqref", "", (String)seqidMap.get(gs[0]));
                handler.startElement("", "", "seq", attr);
                handler.endElement("", "", "seq");
                attr.clear();
                attr.addAttribute("", "", "name", "", "source");
                attr.addAttribute("", "", "value", "", gs[1]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "type");
                attr.addAttribute("", "", "value", "", gs[2]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "start");
                attr.addAttribute("", "", "value", "", gs[3]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "end");
                attr.addAttribute("", "", "value", "", gs[4]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "score");
                attr.addAttribute("", "", "value", "", gs[5]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "strand");
                attr.addAttribute("", "", "value", "", gs[6]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "phase");
                attr.addAttribute("", "", "value", "", gs[7]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                attr.clear();
                attr.addAttribute("", "", "name", "", "attributes");
                attr.addAttribute("", "", "value", "", gs[8]);
                handler.startElement("", "", "feature", attr);
                handler.endElement("", "", "feature");
                handler.endElement("", "", "seqinfo");
            }
            handler.endElement("", "", "list_of_seqinfos");
            handler.endElement("", "", "ngs");
            handler.endDocument();
            fos.flush();
            fos.close();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return -1;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return -1;
        }
        return 1;
    }

    @Override
    public Document convert(GFF3File file) throws NGSException {
        Document doc = CheckFactory.getInstance().buildNew();
        Element ngsElement = doc.getRootElement();
        ngsElement.addAttribute("refFileType", "GFF3");
        Element listHeaders = doc.getRootElement().addElement("header_lines");
        Element listSeqs = doc.getRootElement().addElement("list_of_seqs");
        Element listSeqinfos = doc.getRootElement().addElement("list_of_seqinfos");
        this.resetSequentialNumber();
        for (GFF3File.GFF3Header header : file.getHeader()) {
            String commentTag = header.getCommentTag();
            String name = header.getName();
            String value = header.getValue();
            Element meta_info = listHeaders.addElement("meta_info");
            meta_info.addAttribute("name", name);
            meta_info.addAttribute("value", value);
            meta_info.addAttribute("commentTag", commentTag);
        }
        HashMap<String, String> seqidMap = new HashMap<String, String>();
        for (String[] gs : file.getSeqsArray()) {
            String nid = "";
            if (seqidMap.containsKey(gs[0])) {
                nid = (String)seqidMap.get(gs[0]);
            } else {
                nid = this.getUniqueNid(doc);
                seqidMap.put(gs[0], nid);
                Element seq = listSeqs.addElement("seq");
                seq.addAttribute("nid", nid);
                Element origin = seq.addElement("origin");
                origin.setText(gs[0]);
            }
            Element seqinfo = listSeqinfos.addElement("seqinfo");
            seqinfo.addAttribute("nid", this.getUniqueSeqinfoNid(doc));
            Element seqinfo_seq = seqinfo.addElement("seq");
            seqinfo_seq.addAttribute("seqref", nid);
            Element seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "source");
            seqinfo_feature.addAttribute("value", gs[1]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "type");
            seqinfo_feature.addAttribute("value", gs[2]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "start");
            seqinfo_feature.addAttribute("value", gs[3]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "end");
            seqinfo_feature.addAttribute("value", gs[4]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "score");
            seqinfo_feature.addAttribute("value", gs[5]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "strand");
            seqinfo_feature.addAttribute("value", gs[6]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "phase");
            seqinfo_feature.addAttribute("value", gs[7]);
            seqinfo_feature = seqinfo.addElement("feature");
            seqinfo_feature.addAttribute("name", "attributes");
            seqinfo_feature.addAttribute("value", gs[8]);
        }
        return doc;
    }
}

