/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.AbstractNGSFile;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.util.FileHelper;
import java.util.ArrayList;
import java.util.List;

public class GFF3File
extends AbstractNGSFile {
    private List<GFF3Header> heads = new ArrayList<GFF3Header>();
    private List<GFF3Seq> seqs = new ArrayList<GFF3Seq>();
    ArrayList<String[]> seq_lines = new ArrayList();

    public GFF3File() {
        super(Converter.FileType.GFF3, true);
    }

    List<GFF3Header> getHeader() {
        return this.heads;
    }

    List<GFF3Seq> getSeqs() {
        return this.seqs;
    }

    ArrayList<String[]> getSeqsArray() {
        return this.seq_lines;
    }

    public int getSeqCount() {
        return this.seqs.size();
    }

    public int getHeadCount() {
        return this.heads.size();
    }

    public void addHead(String commentTag, String name, String value) {
        this.heads.add(new GFF3Header(commentTag, name, value));
    }

    public void addSeq(String seqid, String source, String type, String start, String end, String score, String strand, String phase, String attributes) {
        this.seqs.add(new GFF3Seq(seqid, source, type, start, end, score, strand, phase, attributes));
    }

    @Override
    public NGSFile read(String file) throws Exception {
        String fileContent = FileHelper.read(file);
        if (fileContent == null) {
            return null;
        }
        fileContent = fileContent.replaceAll("(\\r)?\\n", "\n");
        String[] separated = fileContent.split("\n");
        this.seq_lines.clear();
        block0: for (String separated1 : separated) {
            String line = separated1;
            if (line.isEmpty()) continue;
            if (line.startsWith("#")) {
                String commentTag = "";
                String name = "";
                String value = "";
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c == '#' || c == '!') continue;
                    commentTag = line.substring(0, i);
                    String name_value = line.substring(i);
                    for (int j = 0; j < name_value.length(); ++j) {
                        c = name_value.charAt(j);
                        if (c != ' ') continue;
                        name = name_value.substring(0, j);
                        value = name_value.substring(j + 1);
                        this.addHead(commentTag, name, value);
                        continue block0;
                    }
                    continue block0;
                }
                continue;
            }
            String[] seq_line = new String[9];
            String[] sArray = line.split("\t");
            seq_line[0] = sArray[0];
            seq_line[1] = sArray[1];
            seq_line[2] = sArray[2];
            seq_line[3] = sArray[3];
            seq_line[4] = sArray[4];
            seq_line[5] = sArray[5];
            seq_line[6] = sArray[6];
            seq_line[7] = sArray[7];
            seq_line[8] = sArray[8];
            this.seq_lines.add(seq_line);
        }
        return this;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.heads.size(); ++i) {
            GFF3Header gh = this.heads.get(i);
            sb.append(gh.toString());
            sb.append(System.getProperty("line.separator"));
        }
        for (i = 0; i < this.seqs.size(); ++i) {
            GFF3Seq sq = this.seqs.get(i);
            sb.append(sq.toString());
            if (i == this.seqs.size() - 1) continue;
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    class GFF3Seq {
        public String seqid;
        public String source;
        public String type;
        public String start;
        public String end;
        public String score;
        public String strand;
        public String phase;
        public String attributes;

        public GFF3Seq(String seqid, String source, String type, String start, String end, String score, String strand, String phase, String attributes) {
            this.seqid = seqid;
            this.source = source;
            this.type = type;
            this.start = start;
            this.end = end;
            this.score = score;
            this.strand = strand;
            this.phase = phase;
            this.attributes = attributes;
        }

        public String toString() {
            return this.seqid + "\t" + this.source + "\t" + this.type + "\t" + this.start + "\t" + this.end + "\t" + this.score + "\t" + this.strand + "\t" + this.phase + "\t" + this.attributes;
        }
    }

    class GFF3Header {
        String commentTag;
        String name;
        String value;

        public GFF3Header(String commentTag, String name, String value) {
            this.commentTag = commentTag;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.commentTag + this.name + " " + this.value;
        }

        public String getCommentTag() {
            return this.commentTag;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

