/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.AbstractConverter;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.core.conversion.SAMFile;
import cn.edu.suda.ngsml.core.conversion.SAMSAXHandler;
import cn.edu.suda.ngsmllib.CheckFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class SAMConverter
extends AbstractConverter<SAMFile> {
    private List<ReadGroup> readGroups = new ArrayList<ReadGroup>();
    private List<Program> programs = new ArrayList<Program>();

    public SAMConverter() {
        super(Converter.FileType.SAM);
    }

    @Override
    public Document convert(SAMFile file) throws NGSException {
        Document doc = CheckFactory.getInstance().buildNew();
        Element ngsElement = doc.getRootElement();
        ngsElement.addAttribute("refFileType", "SAM");
        Element listHeaders = doc.getRootElement().addElement("header_lines");
        Element listSeqs = doc.getRootElement().addElement("list_of_seqs");
        Element listQuals = doc.getRootElement().addElement("list_of_quals");
        Element listSeqinfos = doc.getRootElement().addElement("list_of_seqinfos");
        this.resetSequentialNumber();
        for (SAMFile.SAMHeader header : file.getHeader()) {
            String tag = header.getTag();
            String value = header.getText();
            Element meta_info = listHeaders.addElement("meta_info");
            meta_info.addAttribute("name", tag);
            meta_info.addAttribute("value", value);
        }
        boolean qualStar = false;
        String qualNidStar = "";
        for (SAMFile.SAMLine line : file.getAlignment()) {
            String optionalField;
            String[] cols;
            Element seqinfo_qual;
            Element originQual;
            Element qual;
            String QNAME = line.getValueAt(0);
            String FLAG = line.getValueAt(1);
            String RNAME = line.getValueAt(2);
            String POS = line.getValueAt(3);
            String MAPQ = line.getValueAt(4);
            String CIGAR = line.getValueAt(5);
            String RNEXT = line.getValueAt(6);
            String PNEXT = line.getValueAt(7);
            String TLEN = line.getValueAt(8);
            String SEQ = line.getValueAt(9);
            String QUAL = line.getValueAt(10);
            Element seq = listSeqs.addElement("seq");
            String seqNid = this.getUniqueNid(doc);
            seq.addAttribute("nid", seqNid);
            Element originSeq = seq.addElement("origin");
            originSeq.setText(SEQ);
            String qualNid = "";
            if (QUAL.equals("*")) {
                if (!qualStar) {
                    qual = listQuals.addElement("qual");
                    qualNid = this.getUniqueNid(doc);
                    qual.addAttribute("nid", qualNid);
                    originQual = qual.addElement("origin");
                    originQual.setText(QUAL);
                    qualNidStar = qualNid;
                    qualStar = true;
                }
            } else {
                qual = listQuals.addElement("qual");
                qualNid = this.getUniqueNid(doc);
                qual.addAttribute("nid", qualNid);
                originQual = qual.addElement("origin");
                originQual.setText(QUAL);
            }
            Element seqinfo = listSeqinfos.addElement("seqinfo");
            seqinfo.addAttribute("nid", this.getUniqueNid(doc));
            seqinfo.addAttribute("name", QNAME);
            Element seqinfo_seq = seqinfo.addElement("seq");
            seqinfo_seq.addAttribute("seqref", seqNid);
            if (QUAL.equals("*")) {
                seqinfo_qual = seqinfo.addElement("qual");
                seqinfo_qual.addAttribute("qualref", qualNidStar);
            } else {
                seqinfo_qual = seqinfo.addElement("qual");
                seqinfo_qual.addAttribute("qualref", qualNid);
            }
            Element seqinfo_feature_FLAG = seqinfo.addElement("feature");
            seqinfo_feature_FLAG.addAttribute("name", "FLAG");
            seqinfo_feature_FLAG.addAttribute("value", FLAG);
            Element seqinfo_feature_RNAME = seqinfo.addElement("feature");
            seqinfo_feature_RNAME.addAttribute("name", "RNAME");
            seqinfo_feature_RNAME.addAttribute("value", RNAME);
            Element seqinfo_feature_POS = seqinfo.addElement("feature");
            seqinfo_feature_POS.addAttribute("name", "POS");
            seqinfo_feature_POS.addAttribute("value", POS);
            Element seqinfo_feature_MAPQ = seqinfo.addElement("feature");
            seqinfo_feature_MAPQ.addAttribute("name", "MAPQ");
            seqinfo_feature_MAPQ.addAttribute("value", MAPQ);
            Element seqinfo_feature_CIGAR = seqinfo.addElement("feature");
            seqinfo_feature_CIGAR.addAttribute("name", "CIGAR");
            seqinfo_feature_CIGAR.addAttribute("value", CIGAR);
            Element seqinfo_feature_RNEXT = seqinfo.addElement("feature");
            seqinfo_feature_RNEXT.addAttribute("name", "RNEXT");
            seqinfo_feature_RNEXT.addAttribute("value", RNEXT);
            Element seqinfo_feature_PNEXT = seqinfo.addElement("feature");
            seqinfo_feature_PNEXT.addAttribute("name", "PNEXT");
            seqinfo_feature_PNEXT.addAttribute("value", PNEXT);
            Element seqinfo_feature_TLEN = seqinfo.addElement("feature");
            seqinfo_feature_TLEN.addAttribute("name", "TLEN");
            seqinfo_feature_TLEN.addAttribute("value", TLEN);
            if (line.getColCount() != 12 || (cols = (optionalField = line.getValueAt(11)).split(":")).length < 3) continue;
            String strOptionalTag = cols[0] + ":" + cols[1];
            String strOptionalValue = cols[2];
            Element seqinfo_feature_OPTIONAL = seqinfo.addElement("feature");
            seqinfo_feature_OPTIONAL.addAttribute("name", strOptionalTag);
            seqinfo_feature_OPTIONAL.addAttribute("value", strOptionalValue);
        }
        return doc;
    }

    @Override
    public int convert(SAMFile ngs_file, String ngsml_file) throws NGSException {
        return 1;
    }

    @Override
    public int convert(String ngsml_file, String ngs_file) throws NGSException {
        return 1;
    }

    @Override
    public NGSFile convert(Document doc) throws NGSException {
        SAMFile sam = new SAMFile();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        List<Node> headerList = doc.getRootElement().selectNodes("*[name()='header_lines']/*[name()='meta_info']");
        for (Node objHeader : headerList) {
            if (!(objHeader instanceof Element)) continue;
            Element e = (Element)objHeader;
            String tag = e.attributeValue("name");
            String value = e.attributeValue("value", "");
            value = value.replace(" ", "\t");
            sam.addHeader(tag, value);
        }
        List<Node> lineList = doc.getRootElement().selectNodes("*[name()='list_of_seqinfos']/*[name()='seqinfo']");
        for (Node obj : lineList) {
            attrs.clear();
            if (obj instanceof Element) {
                Element e = (Element)obj;
                String QNAME = e.attributeValue("name");
                attrs.put("QNAME", QNAME);
                String seqref = e.element("seq").attributeValue("seqref");
                String seqValue = this.getOrigin(doc, "*[name()='list_of_seqs']/*[name()='seq']", seqref);
                attrs.put("SEQ", seqValue);
                String qualref = e.element("qual").attributeValue("qualref");
                String qualValue = this.getOrigin(doc, "*[name()='list_of_quals']/*[name()='qual']", qualref);
                attrs.put("QUAL", qualValue);
                List<Element> readFeatures = e.elements("feature");
                for (Element objFeature : readFeatures) {
                    if (!(objFeature instanceof Element)) continue;
                    Element f = objFeature;
                    String fname = f.attributeValue("name");
                    String fvalue = f.attributeValue("value");
                    if (!fname.contains(":")) {
                        attrs.put(fname, fvalue);
                        continue;
                    }
                    attrs.put("TAG", fname + ":" + fvalue);
                }
            }
            ArrayList<String> cols = new ArrayList<String>();
            cols.add((String)attrs.get("QNAME"));
            cols.add((String)attrs.get("FLAG"));
            cols.add((String)attrs.get("RNAME"));
            cols.add((String)attrs.get("POS"));
            cols.add((String)attrs.get("MAPQ"));
            cols.add((String)attrs.get("CIGAR"));
            cols.add((String)attrs.get("RNEXT"));
            cols.add((String)attrs.get("PNEXT"));
            cols.add((String)attrs.get("TLEN"));
            cols.add((String)attrs.get("SEQ"));
            cols.add((String)attrs.get("QUAL"));
            if (attrs.containsKey("TAG")) {
                cols.add((String)attrs.get("TAG"));
            }
            sam.addLine(cols);
        }
        return sam;
    }

    @Override
    public NGSFile convert(String file) throws NGSException {
        SAMFile sf = new SAMFile();
        SAXReader saxReader = new SAXReader();
        try {
            SAMSAXHandler samElementHandler = new SAMSAXHandler(sf);
            saxReader.addHandler("/ngs/header_lines/meta_info", samElementHandler);
            saxReader.addHandler("/ngs/list_of_seqs/seq", samElementHandler);
            saxReader.addHandler("/ngs/list_of_quals/qual", samElementHandler);
            saxReader.addHandler("/ngs/list_of_seqinfos/seqinfo", samElementHandler);
            saxReader.read(new File(file));
        }
        catch (UnsupportedOperationException | DocumentException ex) {
            throw new NGSException(ex.toString());
        }
        return sf;
    }

    private void processReadFeature(Element read, List<String> line, SAMFile sam) {
        List<Element> features = read.elements("feature");
        for (Element obj : features) {
            String name;
            if (!(obj instanceof Element)) continue;
            Element feature = obj;
            switch (name = feature.attributeValue("name")) {
                case "sam_nm": {
                    line.add("NM:i:" + feature.attributeValue("value"));
                    break;
                }
                case "sam_sm": {
                    line.add("SM:i:" + feature.attributeValue("value"));
                    break;
                }
                case "sam_md": {
                    line.add("MD:Z:" + feature.attributeValue("value"));
                    break;
                }
                case "sam_am": {
                    line.add("AM:i:" + feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_id": {
                    ReadGroup rg = this.createRG(feature.attributeValue("value"), read);
                    this.addRG(rg, sam);
                    break;
                }
                case "sam_pg_id": {
                    Program pg = this.createPG(feature.attributeValue("value"), read);
                    this.addPG(pg, sam);
                }
            }
        }
    }

    private ReadGroup createRG(String id, Element read) {
        ReadGroup rg = new ReadGroup(id);
        List<Element> features = read.elements("feature");
        for (Element obj : features) {
            String name;
            if (!(obj instanceof Element)) continue;
            Element feature = obj;
            switch (name = feature.attributeValue("name")) {
                case "sam_rg_cn": {
                    rg.setCn(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_ds": {
                    rg.setDs(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_dt": {
                    rg.setDt(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_fo": {
                    rg.setFo(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_ks": {
                    rg.setKs(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_lb": {
                    rg.setLb(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_pg": {
                    rg.setPg(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_pi": {
                    rg.setPi(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_pl": {
                    rg.setPl(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_pu": {
                    rg.setPu(feature.attributeValue("value"));
                    break;
                }
                case "sam_rg_sm": {
                    rg.setSm(feature.attributeValue("value"));
                }
            }
        }
        return rg;
    }

    private void addRG(ReadGroup rg, SAMFile sam) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        String v = rg.getId();
        attrs.put("ID", v);
        v = rg.getCn();
        if (!v.isEmpty()) {
            attrs.put("CN", v);
        }
        if (!(v = rg.getDs()).isEmpty()) {
            attrs.put("DS", v);
        }
        if (!(v = rg.getDt()).isEmpty()) {
            attrs.put("DT", v);
        }
        if (!(v = rg.getFo()).isEmpty()) {
            attrs.put("FO", v);
        }
        if (!(v = rg.getKs()).isEmpty()) {
            attrs.put("KS", v);
        }
        if (!(v = rg.getLb()).isEmpty()) {
            attrs.put("LB", v);
        }
        if (!(v = rg.getPg()).isEmpty()) {
            attrs.put("PG", v);
        }
        if (!(v = rg.getPi()).isEmpty()) {
            attrs.put("PI", v);
        }
        if (!(v = rg.getPl()).isEmpty()) {
            attrs.put("PL", v);
        }
        if (!(v = rg.getPu()).isEmpty()) {
            attrs.put("PU", v);
        }
        if (!(v = rg.getSm()).isEmpty()) {
            attrs.put("SM", v);
        }
        sam.addHeader("@RG", attrs);
    }

    private Program createPG(String id, Element read) {
        Program pg = new Program(id);
        List<Element> features = read.elements("feature");
        for (Element obj : features) {
            String name;
            if (!(obj instanceof Element)) continue;
            Element feature = obj;
            switch (name = feature.attributeValue("name")) {
                case "sam_pg_pn": {
                    pg.setPn(feature.attributeValue("value"));
                    break;
                }
                case "sam_pg_cl": {
                    pg.setCl(feature.attributeValue("value"));
                }
            }
        }
        return pg;
    }

    private void addPG(Program pg, SAMFile sam) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        String v = pg.getId();
        attrs.put("ID", v);
        v = pg.getPn();
        if (!v.isEmpty()) {
            attrs.put("PN", v);
        }
        if (!(v = pg.getCl()).isEmpty()) {
            attrs.put("CL", v);
        }
        sam.addHeader("@PG", attrs);
    }

    private String getOrigin(Document doc, String xpath, String nid) {
        List<Node> list = doc.getRootElement().selectNodes(xpath);
        for (Node obj : list) {
            Element e;
            String enid;
            if (!(obj instanceof Element) || !nid.equals(enid = (e = (Element)obj).attributeValue("nid"))) continue;
            return e.elementText("origin");
        }
        return null;
    }

    private void loadRG(Element read, String id) {
        for (ReadGroup rg : this.readGroups) {
            if (!rg.getId().equals(id)) continue;
            Element feature = read.addElement("feature");
            feature.addAttribute("name", "sam_rg_id");
            feature.addAttribute("value", rg.getId());
            if (!rg.getCn().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_cn");
                feature.addAttribute("value", rg.getCn());
            }
            if (!rg.getDs().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_ds");
                feature.addAttribute("value", rg.getDs());
            }
            if (!rg.getDt().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_dt");
                feature.addAttribute("value", rg.getDt());
            }
            if (!rg.getFo().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_fo");
                feature.addAttribute("value", rg.getFo());
            }
            if (!rg.getKs().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_ks");
                feature.addAttribute("value", rg.getKs());
            }
            if (!rg.getLb().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_lb");
                feature.addAttribute("value", rg.getLb());
            }
            if (!rg.getPg().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_pg");
                feature.addAttribute("value", rg.getPg());
            }
            if (!rg.getPi().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_pi");
                feature.addAttribute("value", rg.getPi());
            }
            if (!rg.getPl().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_pl");
                feature.addAttribute("value", rg.getPl());
            }
            if (!rg.getPu().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_rg_pu");
                feature.addAttribute("value", rg.getPu());
            }
            if (rg.getSm().isEmpty()) continue;
            feature = read.addElement("feature");
            feature.addAttribute("name", "sam_rg_sm");
            feature.addAttribute("value", rg.getSm());
        }
    }

    private void loadPG(Element read, String id) {
        for (Program pg : this.programs) {
            if (!pg.getId().equals(id)) continue;
            Element feature = read.addElement("feature");
            feature.addAttribute("name", "sam_pg_id");
            feature.addAttribute("value", pg.getId());
            if (!pg.getPn().isEmpty()) {
                feature = read.addElement("feature");
                feature.addAttribute("name", "sam_pg_pn");
                feature.addAttribute("value", pg.getPn());
            }
            if (pg.getCl().isEmpty()) continue;
            feature = read.addElement("feature");
            feature.addAttribute("name", "sam_pg_cl");
            feature.addAttribute("value", pg.getCl());
        }
    }

    private void loadFeature(Element read, String name, String value) {
        Element feature = read.addElement("feature");
        feature.addAttribute("name", "sam_" + name.toLowerCase());
        feature.addAttribute("value", value);
    }

    private Element insertSeq(String nid, String seq) {
        Element e = DocumentFactory.getInstance().createElement(new QName("seq", new Namespace("", "http://www.sysbio.org.cn/ngsml/version1")));
        e.addAttribute("nid", nid);
        Element ori = e.addElement("origin");
        ori.setText(seq);
        return e;
    }

    private Element insertQual(String nid, String qual) {
        Element e = DocumentFactory.getInstance().createElement(new QName("qual", new Namespace("", "http://www.sysbio.org.cn/ngsml/version1")));
        e.addAttribute("nid", nid);
        Element ori = e.addElement("origin");
        ori.setText(qual);
        return e;
    }

    private Element addRead(SAMFile.SAMLine line) {
        Element read = DocumentFactory.getInstance().createElement(new QName("read", new Namespace("", "http://www.sysbio.org.cn/ngsml/version1")));
        read.addAttribute("name", line.getValueAt(0));
        read.addAttribute("start", line.getValueAt(3));
        read.addAttribute("qual", line.getValueAt(4));
        String att = line.getValueAt(5);
        if (!att.equals("*")) {
            read.addAttribute("CIGAR", att);
        }
        return read;
    }

    private Element readSQ(SAMFile.SAMHeader header) {
        String ur;
        Element e = DocumentFactory.getInstance().createElement(new QName("seqinfo", new Namespace("", "http://www.sysbio.org.cn/ngsml/version1")));
        String sn = header.getAttr("SN");
        e.addAttribute("nid", sn);
        String sp = header.getAttr("SP");
        if (sp != null) {
            e.addAttribute("organism", sp);
        }
        Element seq = e.addElement("seq");
        seq.addAttribute("seqref", "_");
        Element contigs = e.addElement("contigs");
        contigs.addAttribute("type", "alignment");
        String ln = header.getAttr("LN");
        Element feature = e.addElement("feature");
        feature.addAttribute("name", "sam_ln");
        feature.addAttribute("value", ln);
        String as = header.getAttr("AS");
        if (as != null) {
            feature = e.addElement("feature");
            feature.addAttribute("name", "sam_as");
            feature.addAttribute("value", as);
        }
        if ((ur = header.getAttr("UR")) != null) {
            feature = e.addElement("feature");
            feature.addAttribute("name", "sam_ur");
            feature.addAttribute("value", ur);
        }
        String m5 = header.getAttr("M5");
        if (ur != null) {
            feature = e.addElement("feature");
            feature.addAttribute("name", "sam_m5");
            feature.addAttribute("value", m5);
        }
        return e;
    }

    private void readRG(SAMFile.SAMHeader header) {
        ReadGroup rg = new ReadGroup();
        Iterator<String> iterator = header.getAttrs().keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "id": {
                    rg.setId(header.getAttr(key));
                    break;
                }
                case "cn": {
                    rg.setCn(header.getAttr(key));
                    break;
                }
                case "ds": {
                    rg.setDs(header.getAttr(key));
                    break;
                }
                case "dt": {
                    rg.setDt(header.getAttr(key));
                    break;
                }
                case "fo": {
                    rg.setFo(header.getAttr(key));
                    break;
                }
                case "ks": {
                    rg.setKs(header.getAttr(key));
                    break;
                }
                case "lb": {
                    rg.setLb(header.getAttr(key));
                    break;
                }
                case "pg": {
                    rg.setPg(header.getAttr(key));
                    break;
                }
                case "pi": {
                    rg.setPi(header.getAttr(key));
                    break;
                }
                case "pl": {
                    rg.setPl(header.getAttr(key));
                    break;
                }
                case "pu": {
                    rg.setPu(header.getAttr(key));
                    break;
                }
                case "sm": {
                    rg.setSm(header.getAttr(key));
                }
            }
        }
        this.readGroups.add(rg);
    }

    private void readPG(SAMFile.SAMHeader header) {
        Program pg = new Program();
        Iterator<String> iterator = header.getAttrs().keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "id": {
                    pg.setId(header.getAttr(key));
                    break;
                }
                case "pn": {
                    pg.setPn(header.getAttr(key));
                    break;
                }
                case "cl": {
                    pg.setCl(header.getAttr(key));
                }
            }
        }
        this.programs.add(pg);
    }

    class Program {
        private String id = "";
        private String pn = "";
        private String cl = "";

        Program() {
        }

        Program(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPn() {
            return this.pn;
        }

        public void setPn(String pn) {
            this.pn = pn;
        }

        public String getCl() {
            return this.cl;
        }

        public void setCl(String cl) {
            this.cl = cl;
        }
    }

    class ReadGroup {
        private String id = "";
        private String cn = "";
        private String ds = "";
        private String dt = "";
        private String fo = "";
        private String ks = "";
        private String lb = "";
        private String pg = "";
        private String pi = "";
        private String pl = "";
        private String pu = "";
        private String sm = "";

        ReadGroup() {
        }

        ReadGroup(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCn() {
            return this.cn;
        }

        public void setCn(String cn) {
            this.cn = cn;
        }

        public String getDs() {
            return this.ds;
        }

        public void setDs(String ds) {
            this.ds = ds;
        }

        public String getDt() {
            return this.dt;
        }

        public void setDt(String dt) {
            this.dt = dt;
        }

        public String getFo() {
            return this.fo;
        }

        public void setFo(String fo) {
            this.fo = fo;
        }

        public String getKs() {
            return this.ks;
        }

        public void setKs(String ks) {
            this.ks = ks;
        }

        public String getLb() {
            return this.lb;
        }

        public void setLb(String lb) {
            this.lb = lb;
        }

        public String getPg() {
            return this.pg;
        }

        public void setPg(String pg) {
            this.pg = pg;
        }

        public String getPi() {
            return this.pi;
        }

        public void setPi(String pi) {
            this.pi = pi;
        }

        public String getPl() {
            return this.pl;
        }

        public void setPl(String pl) {
            this.pl = pl;
        }

        public String getPu() {
            return this.pu;
        }

        public void setPu(String pu) {
            this.pu = pu;
        }

        public String getSm() {
            return this.sm;
        }

        public void setSm(String sm) {
            this.sm = sm;
        }
    }
}

