/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.AbstractNGSFile;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.util.DataHelper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SAMFile
extends AbstractNGSFile {
    private List<SAMHeader> header = new ArrayList<SAMHeader>();
    private List<SAMLine> alignment = new ArrayList<SAMLine>();

    public SAMFile() {
        super(Converter.FileType.SAM, true);
    }

    List<SAMHeader> getHeader() {
        return this.header;
    }

    List<SAMLine> getAlignment() {
        return this.alignment;
    }

    public void addHeader(String tag, Map<String, String> attrs) {
        SAMHeader h = new SAMHeader(tag);
        h.setAttrs(DataHelper.cloneMap(attrs));
        this.header.add(h);
    }

    public void addHeader(String tag, String text) {
        SAMHeader h = new SAMHeader(tag);
        h.setText(text);
        this.header.add(h);
    }

    public void addLine(List<String> cols) {
        this.alignment.add(new SAMLine(DataHelper.cloneList(cols)));
    }

    public String getValueAt(int row, int col) {
        return this.alignment.get(row).getValueAt(col);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SAMHeader head : this.header) {
            sb.append(head.toString()).append(System.getProperty("line.separator"));
        }
        for (int i = 0; i < this.alignment.size(); ++i) {
            sb.append(this.alignment.get(i).toString());
            if (i == this.alignment.size() - 1) continue;
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    @Override
    public NGSFile read(String file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith("@")) {
                this.header.add(this.readHeader(line));
                continue;
            }
            this.alignment.add(this.readAlignment(line));
        }
        return this;
    }

    private SAMHeader readHeader(String line) {
        String[] cols = line.split("\t");
        String tag = cols[0];
        SAMHeader head = new SAMHeader(tag);
        if (tag.equals("@CO")) {
            head.setText(cols[1]);
        } else {
            StringBuilder strValue = new StringBuilder();
            for (int i = 1; i < cols.length; ++i) {
                strValue.append(cols[i]);
                if (i == cols.length - 1) continue;
                strValue.append("\t");
            }
            head.setText(strValue.toString());
        }
        return head;
    }

    private SAMLine readAlignment(String line) {
        String[] cols = line.split("\t");
        SAMLine sl = new SAMLine(Arrays.asList(cols));
        return sl;
    }

    class SAMLine {
        private List<String> cols = new ArrayList<String>();

        public SAMLine() {
        }

        public SAMLine(List<String> cols) {
            this.cols = cols;
        }

        public String getValueAt(int col) {
            return this.cols.get(col);
        }

        public void setValueAt(int col, String value) {
            this.cols.set(col, value);
        }

        public List<String> getCols() {
            return this.cols;
        }

        public int getColCount() {
            return this.cols.size();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String col : this.cols) {
                sb.append(col).append("\t");
            }
            return sb.toString().trim();
        }
    }

    class SAMHeader {
        private String tag = "";
        private Map<String, String> attrs = new LinkedHashMap<String, String>();
        private String text = "";

        public SAMHeader(String tag) {
            this.tag = tag;
        }

        public void putAttr(String name, String value) {
            this.attrs.put(name, value);
        }

        public String getTag() {
            return this.tag;
        }

        public String getAttr(String name) {
            return this.attrs.get(name);
        }

        public Map<String, String> getAttrs() {
            return this.attrs;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tag);
            sb.append("\t");
            sb.append(this.text);
            return sb.toString();
        }

        void setAttrs(Map<String, String> attrs) {
            this.attrs = attrs;
        }
    }
}

