/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.core.conversion;

import cn.edu.suda.ngsml.core.conversion.SAMFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.ElementPath;

public class SAMSAXHandler
implements ElementHandler {
    SAMFile sam = null;
    Map<String, String> attrs = null;
    Map<String, String> seqs = null;
    Map<String, String> quals = null;

    public SAMSAXHandler(SAMFile sf) {
        this.sam = sf;
        this.attrs = new LinkedHashMap<String, String>();
        this.seqs = new LinkedHashMap<String, String>();
        this.quals = new LinkedHashMap<String, String>();
    }

    @Override
    public void onStart(ElementPath ep) {
    }

    @Override
    public void onEnd(ElementPath ep) {
        Element node = ep.getCurrent();
        String nodePath = ep.getPath();
        if (nodePath.equals("/ngs/header_lines/meta_info")) {
            String tag = node.attributeValue("name");
            String value = node.attributeValue("value", "");
            value = value.replace(" ", "\t");
            this.sam.addHeader(tag, value);
        } else if (nodePath.equals("/ngs/list_of_seqs/seq")) {
            String nid = node.attributeValue("nid");
            String seq = node.elementText("origin");
            this.seqs.put(nid, seq);
        } else if (nodePath.equals("/ngs/list_of_quals/qual")) {
            String nid = node.attributeValue("nid");
            String seq = node.elementText("origin");
            this.quals.put(nid, seq);
        } else if (nodePath.equals("/ngs/list_of_seqinfos/seqinfo")) {
            this.attrs.clear();
            String QNAME = node.attributeValue("name");
            this.attrs.put("QNAME", QNAME);
            String seqref = node.element("seq").attributeValue("seqref");
            String seqValue = this.seqs.get(seqref);
            this.attrs.put("SEQ", seqValue);
            String qualref = node.element("qual").attributeValue("qualref");
            String qualValue = this.quals.get(qualref);
            this.attrs.put("QUAL", qualValue);
            List<Element> readFeatures = node.elements("feature");
            Iterator<Element> iterator = readFeatures.iterator();
            while (iterator.hasNext()) {
                Element objFeature;
                Element f = objFeature = iterator.next();
                String fname = f.attributeValue("name");
                String fvalue = f.attributeValue("value");
                if (!fname.contains(":")) {
                    this.attrs.put(fname, fvalue);
                    continue;
                }
                this.attrs.put("TAG", fname + ":" + fvalue);
            }
            ArrayList<String> cols = new ArrayList<String>();
            cols.add(this.attrs.get("QNAME"));
            cols.add(this.attrs.get("FLAG"));
            cols.add(this.attrs.get("RNAME"));
            cols.add(this.attrs.get("POS"));
            cols.add(this.attrs.get("MAPQ"));
            cols.add(this.attrs.get("CIGAR"));
            cols.add(this.attrs.get("RNEXT"));
            cols.add(this.attrs.get("PNEXT"));
            cols.add(this.attrs.get("TLEN"));
            cols.add(this.attrs.get("SEQ"));
            cols.add(this.attrs.get("QUAL"));
            if (this.attrs.containsKey("TAG")) {
                cols.add(this.attrs.get("TAG"));
            }
            this.sam.addLine(cols);
        }
        node.detach();
    }
}

