/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.entrance;

import cn.edu.suda.ngsml.entrance.RunThread;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Manager {
    public static final String programName = "NGSMLEditor";
    public static final String version = "1.0";
    public static final String author = "Bairong Shen, Chunjiang Yu, Wentao Wu";
    public static final String institute = "SOOCHOW UNIVERSITY Center for Systems Biology";
    public static final String helpDoc = "NGSMLEditor_manual.html";
    public static final String guide = "NGSMLEditor_manual.html";
    public static final Logger logger = Logger.getLogger(Manager.class.getName());
    public static final String TYPE_HELP = "Conversion Type:\n-fa2ngsml  FASTA to NGSML\n-ngsml2fa  NGSML to FASTA\n-fq2ngsml  FASTQ to NGSML\n-ngsml2fq  NGSML to FASTQ\n-sam2ngsml SAM to NGSML\n-ngsml2sam NGSML to SAM\n-gff32ngsml GFF3 to NGSML\n-ngsml2gff3 NGSML to GFF3\n";
    public static LogManager log = null;

    public Manager() {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%5$s%n");
        logger.setLevel(Level.ALL);
        log = new LogManager(logger);
    }

    public int checkArgs(String[] args) {
        int n = args.length;
        if (n == 0) {
            log.info("NGSMLEditor GUI started!");
            return 0;
        }
        try {
            if (args[0].equals("-h")) {
                this.cmdHelp();
                return 3;
            }
            if (n != 6) {
                log.severe("Arguments not correct!");
                return -1;
            }
            String input = "";
            String output = "";
            String type = "";
            for (int i = 0; i < n; i += 2) {
                if (args[i].equals("-i")) {
                    input = args[i + 1];
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = args[i + 1];
                    continue;
                }
                if (!args[i].equals("-c")) continue;
                type = args[i + 1];
            }
            this.startConvert(input, output, type);
            return 2;
        }
        catch (Exception e) {
            log.severe("Arguments error!");
            return -1;
        }
    }

    public void startConvert(String input, String outputDir, String type) {
        RunThread rt = new RunThread(input, outputDir, type);
        Thread t = new Thread(rt);
        t.start();
    }

    public void cmdHelp() {
        log.console("-c\tConversion type.\n-i\tInput file.\n-o\tOutput file.\n");
        log.console(TYPE_HELP);
        String example = "Example:\njava -jar NGSMLEditor.jar -c fa2ngsml -i path\\xxx.FASTA -o path\\xxx.xml";
        log.console(example);
    }

    public class LogManager {
        Logger logger = null;

        LogManager(Logger loggerobj) {
            this.logger = loggerobj;
        }

        public void info(String str) {
            this.logger.log(Level.INFO, str);
        }

        public void warning(String str) {
            this.logger.warning(str);
        }

        public void severe(String str) {
            this.logger.severe(str);
        }

        public void console(String str) {
            System.out.println(str);
        }
    }
}

