/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.entrance;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.ConvertFactory;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.entrance.Manager;
import cn.edu.suda.ngsml.io.NGSIOFactory;
import cn.edu.suda.ngsml.util.FileHelper;
import java.io.File;
import java.io.IOException;

public class RunThread
implements Runnable {
    private String input;
    private String output;
    private String type;
    private Converter.FileType enum_input;
    private Converter.FileType enum_output;

    public RunThread(String input, String output, String type) {
        this.input = input;
        this.output = output;
        switch (this.type = type) {
            case "fa2ngsml": {
                this.enum_input = Converter.FileType.FASTA;
                this.enum_output = Converter.FileType.XML;
                break;
            }
            case "ngsml2fa": {
                this.enum_input = Converter.FileType.XML;
                this.enum_output = Converter.FileType.FASTA;
                break;
            }
            case "fq2ngsml": {
                this.enum_input = Converter.FileType.FASTQ;
                this.enum_output = Converter.FileType.XML;
                break;
            }
            case "ngsml2fq": {
                this.enum_input = Converter.FileType.XML;
                this.enum_output = Converter.FileType.FASTQ;
                break;
            }
            case "sam2ngsml": {
                this.enum_input = Converter.FileType.SAM;
                this.enum_output = Converter.FileType.XML;
                break;
            }
            case "ngsml2sam": {
                this.enum_input = Converter.FileType.XML;
                this.enum_output = Converter.FileType.SAM;
                break;
            }
            case "gff32ngsml": {
                this.enum_input = Converter.FileType.GFF3;
                this.enum_output = Converter.FileType.XML;
                break;
            }
            case "ngsml2gff3": {
                this.enum_input = Converter.FileType.XML;
                this.enum_output = Converter.FileType.GFF3;
                break;
            }
        }
    }

    @Override
    public void run() {
        long t1 = System.currentTimeMillis();
        Converter converter = null;
        String type = "";
        boolean toXML = true;
        if (this.enum_input == Converter.FileType.XML) {
            converter = ConvertFactory.getInstance().getConverter(this.enum_output);
            type = this.enum_output.toString();
            toXML = false;
        }
        if (this.enum_output == Converter.FileType.XML) {
            converter = ConvertFactory.getInstance().getConverter(this.enum_input);
            type = this.enum_input.toString();
            toXML = true;
        }
        if (converter != null) {
            try {
                String out = this.getOutput(this.output);
                if (toXML) {
                    NGSFile ngsfile = NGSIOFactory.getInstance().read(this.input, type);
                    int n = converter.convert(ngsfile, out);
                }
                int n = converter.convert(this.input, out);
            }
            catch (NGSException | IOException ex) {
                Manager.log.severe(ex.getMessage());
                return;
            }
            catch (Exception ex2) {
                Manager.log.severe(ex2.getMessage());
                return;
            }
        } else {
            Manager.log.severe("Conversion is failed!");
            return;
        }
        long t2 = System.currentTimeMillis();
        float f = (float)(t2 - t1) / 1000.0f;
        String time = f + " seconds";
        Manager.log.info("Conversion Finished successfully.\nUsed Time: " + time);
    }

    private String getOutput(String output) {
        String fileNameSuffix = FileHelper.getFileName(output);
        String filename = FileHelper.getNameWithoutSuffix(output);
        String suffix = FileHelper.getSuffix(fileNameSuffix);
        String outDir = FileHelper.getParentPath(output);
        String out = outDir + File.separator + filename + "." + suffix;
        File file = new File(output);
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        int i = 1;
        while (new File(out).exists()) {
            String fname = filename + "_" + i;
            ++i;
            out = outDir + File.separator + fname + "." + suffix;
        }
        File file1 = new File(out);
        try {
            file1.createNewFile();
        }
        catch (IOException ex) {
            Manager.log.severe("Create file failed!" + out);
        }
        return out;
    }
}

