/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.gui.ConvertWorker;
import cn.edu.suda.ngsml.gui.DocumentHandler;
import cn.edu.suda.ngsml.gui.ExplorerTree;
import cn.edu.suda.ngsml.gui.FileCellRenderer;
import cn.edu.suda.ngsml.gui.MainFrame;
import cn.edu.suda.ngsml.util.FileHelper;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;

public class ConvertFrame
extends JFrame
implements PropertyChangeListener {
    public static final String[] FORMATS = new String[]{"NGSML", "FASTA", "FASTQ", "SAM", "GFF3"};
    private static final Logger LOG = Logger.getLogger(ConvertFrame.class.getName());
    private MainFrame frame = null;
    private JFileChooser jfc;
    private ExplorerTree tree;
    private int mx;
    private int my;
    private int processPos = 0;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTable jTable1;
    private JTextField jTextField1;
    private JTextPane jTextPane1;
    private JToolBar jToolBar1;

    public ConvertFrame(MainFrame frame) {
        this.frame = frame;
        this.initComponents();
        this.init();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public Converter.FileType getFileType(File file) {
        String s = file.getName();
        int dot = s.lastIndexOf(".");
        if (dot == -1) {
            return Converter.FileType.UNKNOW;
        }
        switch (s = s.substring(dot + 1).toLowerCase()) {
            case "xml": {
                return Converter.FileType.XML;
            }
            case "fasta": 
            case "fa": {
                return Converter.FileType.FASTA;
            }
            case "fastq": 
            case "fq": {
                return Converter.FileType.FASTQ;
            }
            case "sam": {
                return Converter.FileType.SAM;
            }
            case "gff3": {
                return Converter.FileType.GFF3;
            }
        }
        return Converter.FileType.UNKNOW;
    }

    public void updateStatus(String file, String status) {
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            if (!this.jTable1.getValueAt(i, 4).toString().equals(file)) continue;
            this.jTable1.setValueAt(status, i, 5);
        }
    }

    public void updateNextStatus(String status) {
        this.jTable1.setValueAt(status, this.processPos, 5);
        ++this.processPos;
    }

    public void updateProgressbar(int n, int sum) {
        float percent = (float)n / (float)sum;
        this.jProgressBar1.setValue((int)(percent * (float)this.jProgressBar1.getMaximum()));
    }

    public void add(File file) {
        if (!file.isFile()) {
            return;
        }
        int id = this.jTable1.getRowCount() + 1;
        JButton bt = new JButton("Open");
        ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{id, file.getName(), this.getFileType(file).toString(), FileHelper.getFileSize(file), file.getAbsolutePath(), "Ready", bt});
    }

    public void addAll(File file) {
        if (!file.isDirectory()) {
            return;
        }
        for (File f : file.listFiles()) {
            this.add(f);
        }
    }

    public void remove() {
        int r = this.jTable1.getSelectedRow();
        String name = this.jTable1.getValueAt(r, 1).toString();
        if (r >= 0) {
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(r);
            this.sortID();
            LOG.info("Remove file: " + name);
        }
    }

    public void clear() {
        if (this.jTable1.getRowCount() <= 0) {
            return;
        }
        for (int i = this.jTable1.getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(i);
        }
        LOG.info("Remove all files.");
    }

    public void openOutput() {
        try {
            Desktop.getDesktop().open(new File(this.jTextField1.getText().trim()));
        }
        catch (IOException ex) {
            LOG.severe("Could't open output directory!");
        }
    }

    public void start() {
        String outtype;
        int i;
        String[] inputs = this.getInputs();
        if (inputs.length == 0) {
            JOptionPane.showMessageDialog(null, "Input file, please.", "Message", 1);
            return;
        }
        for (i = 0; i < inputs.length; ++i) {
            int answer;
            String filePath = inputs[i];
            File f = new File(filePath);
            if (!f.exists() || !f.isFile() || f.length() < 0x40000000L || (answer = JOptionPane.showConfirmDialog(null, "File is larger than 1G, do you really want to go on?", "Confirmation", 0)) != 1) continue;
            return;
        }
        for (i = 0; i < inputs.length; ++i) {
            this.jTable1.setValueAt("Ready", i, 5);
        }
        this.processPos = 0;
        String output = this.jTextField1.getText().trim();
        if (output.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Input output directory, please.", "Message", 1);
            return;
        }
        String intype = this.jButton7.getText();
        if (intype.equals("NGSML")) {
            intype = "XML";
        }
        if ((outtype = this.jButton9.getText()).equals("NGSML")) {
            outtype = "XML";
        }
        ConvertWorker cw = new ConvertWorker(inputs, Converter.FileType.valueOf(intype), Converter.FileType.valueOf(outtype), output, this);
        this.jProgressBar1.setValue(0);
        this.setRunningState(true);
        cw.execute();
    }

    public String[] getInputs() {
        String[] inputs = new String[this.jTable1.getRowCount()];
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            inputs[i] = this.jTable1.getValueAt(i, 4).toString();
        }
        return inputs;
    }

    public void setRunningState(boolean running) {
        this.jButton1.setEnabled(!running);
        this.jButton2.setEnabled(!running);
        this.jButton3.setEnabled(!running);
        this.jButton4.setEnabled(!running);
        this.jButton5.setEnabled(!running);
        this.jButton6.setEnabled(!running);
        this.jButton7.setEnabled(!running);
        this.jButton8.setEnabled(!running);
        this.jButton9.setEnabled(!running);
        this.jButton10.setEnabled(!running);
        this.tree.setEnabled(!running);
        this.jProgressBar1.setVisible(running);
    }

    private void init() {
        this.initTree();
        this.jfc = new JFileChooser();
        this.jButton7.setText(FORMATS[0]);
        this.jButton9.setText(FORMATS[1]);
        this.jProgressBar1.setVisible(true);
        this.jTable1.setSelectionMode(0);
        this.jTable1.setDefaultRenderer(Object.class, new FileCellRenderer());
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ConvertFrame.this.jTable1.getSelectedColumn() == 6) {
                    ConvertFrame.this.openButton(ConvertFrame.this.jTable1.getSelectedRow());
                }
            }
        });
        this.setLocationRelativeTo(null);
        LOG.addHandler(new DocumentHandler(this.jTextPane1));
        LOG.info("Ready.");
    }

    private void initTree() {
        this.tree = new ExplorerTree();
        this.jScrollPane4.setViewportView(this.tree);
        final JPopupMenu pop = new JPopupMenu();
        JMenuItem add = new JMenuItem("Add file");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = ConvertFrame.this.tree.getPath(ConvertFrame.this.tree.getFromXY(ConvertFrame.this.mx, ConvertFrame.this.my));
                File file = new File(path);
                if (file.isFile()) {
                    ConvertFrame.this.add(file);
                } else if (file.isDirectory()) {
                    ConvertFrame.this.addAll(file);
                }
            }
        });
        pop.add(add);
        JMenuItem refresh = new JMenuItem("Refresh");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConvertFrame.this.tree.refresh(ConvertFrame.this.tree.getFromXY(ConvertFrame.this.mx, ConvertFrame.this.my));
            }
        });
        pop.add(refresh);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ConvertFrame.this.mx = e.getX();
                    ConvertFrame.this.my = e.getY();
                    ConvertFrame.this.tree.setSelectionPath(ConvertFrame.this.tree.getFromXY(ConvertFrame.this.mx, ConvertFrame.this.my));
                    pop.show(e.getComponent(), ConvertFrame.this.mx, ConvertFrame.this.my);
                }
            }
        });
    }

    private void openButton(int row) {
        if (this.jTable1.getValueAt(row, 2).toString().equals(Converter.FileType.XML.toString())) {
            if (this.frame != null) {
                if (this.frame.checkSaved() == 2) {
                    return;
                }
                this.frame.openFile(new File(this.jTable1.getValueAt(row, 4).toString()));
                this.frame.requestFocus();
            }
        } else {
            try {
                Desktop.getDesktop().open(new File(this.jTable1.getValueAt(row, 4).toString()));
            }
            catch (IOException ex) {
                LOG.severe("Could't open file!");
            }
        }
    }

    private void sortID() {
        int r = this.jTable1.getRowCount();
        for (int i = 0; i < r; ++i) {
            this.jTable1.setValueAt(i + 1, i, 0);
        }
    }

    private void addButton() {
        this.jfc.setMultiSelectionEnabled(true);
        this.jfc.setFileSelectionMode(0);
        int re = this.jfc.showOpenDialog(this);
        if (re == 0) {
            for (File f : this.jfc.getSelectedFiles()) {
                this.add(f);
            }
        }
    }

    private void addAllButton() {
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(1);
        int re = this.jfc.showOpenDialog(this);
        if (re == 0) {
            this.addAll(this.jfc.getSelectedFile());
        }
    }

    private void browseOutput() {
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(1);
        int re = this.jfc.showOpenDialog(this);
        if (re == 0) {
            this.jTextField1.setText(this.jfc.getSelectedFile().getAbsolutePath());
        }
    }

    private void changeFormat(JButton source) {
        Object obj = JOptionPane.showInputDialog(null, "Select a format:\n", "Formats", 3, null, FORMATS, FORMATS[0]);
        if (obj != null) {
            String re = obj.toString();
            String oppo = re.equals(FORMATS[0]) ? FORMATS[1] : FORMATS[0];
            source.setText(re);
            if (source == this.jButton7) {
                this.jButton9.setText(oppo);
            } else {
                this.jButton7.setText(oppo);
            }
        }
    }

    private void exchangeFormats() {
        String tmp = this.jButton7.getText();
        this.jButton7.setText(this.jButton9.getText());
        this.jButton9.setText(tmp);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel1 = new JLabel();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jLabel2 = new JLabel();
        this.jButton9 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton10 = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel4 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("Converter");
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Name", "Type", "Size", "Path", "State", "Operation"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/add.png")));
        this.jButton1.setText("Add");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setMaximumSize(new Dimension(43, 57));
        this.jButton1.setMinimumSize(new Dimension(43, 57));
        this.jButton1.setPreferredSize(new Dimension(43, 57));
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/addall.png")));
        this.jButton2.setText("AddAll");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/remove.png")));
        this.jButton3.setText("Remove");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/removeall.png")));
        this.jButton4.setText("Clear");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setMaximumSize(new Dimension(43, 57));
        this.jButton4.setMinimumSize(new Dimension(43, 57));
        this.jButton4.setPreferredSize(new Dimension(43, 57));
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/output.png")));
        this.jButton5.setText("Output");
        this.jButton5.setFocusable(false);
        this.jButton5.setHorizontalTextPosition(0);
        this.jButton5.setVerticalTextPosition(3);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton5);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/start.png")));
        this.jButton6.setText("Start");
        this.jButton6.setFocusable(false);
        this.jButton6.setHorizontalTextPosition(0);
        this.jButton6.setMaximumSize(new Dimension(43, 57));
        this.jButton6.setMinimumSize(new Dimension(43, 57));
        this.jButton6.setPreferredSize(new Dimension(43, 57));
        this.jButton6.setVerticalTextPosition(3);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton6ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton6);
        this.jLabel1.setText("Input:");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton7ActionPerformed(evt);
            }
        });
        this.jButton8.setText("<=>");
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton8ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Output:");
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton9ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Output Dir:");
        this.jButton10.setText("Browse");
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConvertFrame.this.jButton10ActionPerformed(evt);
            }
        });
        this.jTextPane1.setEditable(false);
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.jLabel4.setText("Ready");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9, -2, 80, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE))).addGap(4, 4, 4)).addComponent(this.jScrollPane1, -1, 472, Short.MAX_VALUE).addComponent(this.jScrollPane3)))).addContainerGap()));
        layout.linkSize(0, this.jButton7, this.jButton9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 119, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton8, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addComponent(this.jButton9, -1, -1, Short.MAX_VALUE)).addComponent(this.jButton7, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton10)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane3, -1, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.jLabel4))).addComponent(this.jScrollPane4)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addButton();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.addAllButton();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.remove();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.openOutput();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.start();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.browseOutput();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.changeFormat((JButton)evt.getSource());
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.changeFormat((JButton)evt.getSource());
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.exchangeFormats();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ConvertFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ConvertFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ConvertFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ConvertFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ConvertFrame(null).setVisible(true);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

