/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.NGSException;
import cn.edu.suda.ngsml.core.conversion.ConvertFactory;
import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.gui.ConvertFrame;
import cn.edu.suda.ngsml.io.NGSIOFactory;
import cn.edu.suda.ngsml.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class ConvertWorker
extends SwingWorker<List<String>, String> {
    private String[] inputs;
    private Converter.FileType input;
    private Converter.FileType output;
    private String outDir;
    private ConvertFrame frame;
    private String time = "";

    public ConvertWorker(String[] inputs, Converter.FileType input, Converter.FileType output, String outDir, ConvertFrame frame) {
        this.inputs = inputs;
        this.input = input;
        this.output = output;
        this.outDir = outDir;
        this.frame = frame;
    }

    public ConvertWorker(String[] inputs, Converter.FileType input, Converter.FileType output, String outDir) {
        this(inputs, input, output, outDir, null);
    }

    @Override
    protected List<String> doInBackground() throws Exception {
        long t1 = System.currentTimeMillis();
        Converter converter = null;
        String type = "";
        boolean toXML = true;
        ArrayList<String> outputs = new ArrayList<String>();
        if (this.input == Converter.FileType.XML) {
            converter = ConvertFactory.getInstance().getConverter(this.output);
            type = this.output.toString();
            toXML = false;
        }
        if (this.output == Converter.FileType.XML) {
            converter = ConvertFactory.getInstance().getConverter(this.input);
            type = this.input.toString();
            toXML = true;
        }
        if (converter != null) {
            int i = 0;
            for (String in : this.inputs) {
                ++i;
                try {
                    String out = this.getOutput(in);
                    if (toXML) {
                        NGSFile ngsfile = NGSIOFactory.getInstance().read(in, type);
                        int n = converter.convert(ngsfile, out);
                    } else {
                        int n = converter.convert(in, out);
                    }
                    outputs.add(out);
                    this.setProgress(i);
                    this.publish("Finish");
                }
                catch (NGSException | IOException ex) {
                    this.publish("Failed");
                    ConvertFrame.getLogger().severe(ex.getMessage());
                }
                catch (Exception ex2) {
                    this.publish("Failed");
                    ConvertFrame.getLogger().severe(ex2.getMessage());
                }
            }
        } else {
            ConvertFrame.getLogger().severe("Conversion is failed!");
        }
        long t2 = System.currentTimeMillis();
        float f = (float)(t2 - t1) / 1000.0f;
        this.time = f + " s";
        return outputs;
    }

    @Override
    protected void process(List<String> chunks) {
        if (this.frame != null) {
            for (String s : chunks) {
                this.frame.updateNextStatus(s);
            }
            this.frame.updateProgressbar(this.getProgress(), this.inputs.length);
        }
    }

    @Override
    protected void done() {
        try {
            List outputs = (List)this.get();
            if (this.frame != null) {
                this.frame.setRunningState(false);
            }
            StringBuilder sb = new StringBuilder("Finish file(s): ");
            for (String s : outputs) {
                sb.append(new File(s).getName()).append(",");
            }
            ConvertFrame.getLogger().info(sb.toString());
            ConvertFrame.getLogger().info("Done! Used Time: " + this.time);
        }
        catch (InterruptedException | ExecutionException ex) {
            ConvertFrame.getLogger().severe(ex.getMessage());
        }
    }

    private String getOutput(String input) {
        String filename = FileHelper.getNameWithoutSuffix(input);
        String out = this.outDir + File.separator + filename + "." + this.output.toString();
        int i = 1;
        while (new File(out).exists()) {
            String fname = filename + "_" + i;
            ++i;
            out = this.outDir + File.separator + fname + "." + this.output.toString();
        }
        return out;
    }
}

