/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerTree
extends JTree {
    private Map<DefaultMutableTreeNode, Boolean> loading = new HashMap<DefaultMutableTreeNode, Boolean>();

    public ExplorerTree() {
        this.init();
    }

    public String getPath(TreePath tp) {
        Object[] objs = tp.getPath();
        int n = objs.length;
        if (n > 0) {
            if (n <= 2) {
                return objs[n - 1].toString();
            }
            String path = objs[1].toString() + File.separator + objs[2].toString();
            for (int i = 3; i < n; ++i) {
                path = path + File.separator + objs[i].toString();
            }
            return path;
        }
        return "";
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public TreePath getTreePath(TreeNode node) {
        return new TreePath(this.getTreeModel().getPathToRoot(node));
    }

    public DefaultMutableTreeNode getTreeNode(TreePath tp) {
        return (DefaultMutableTreeNode)tp.getLastPathComponent();
    }

    public void refresh(TreePath tp) {
        this.addChildren2(this.getTreeNode(this.getSelectionPath()));
    }

    public TreePath getFromXY(int x, int y) {
        return this.getPathForLocation(x, y);
    }

    private void init() {
        File[] disks;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (File f : disks = File.listRoots()) {
            DefaultMutableTreeNode fn = new DefaultMutableTreeNode(f.getAbsolutePath());
            this.addLoading(fn);
            root.add(fn);
        }
        this.setModel(new DefaultTreeModel(root));
        this.setRootVisible(false);
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                ExplorerTree.this.treeExpand(event.getPath());
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
    }

    private void addLoading(DefaultMutableTreeNode parent) {
        parent.add(new DefaultMutableTreeNode("Loading..."));
    }

    private void addChildren2(DefaultMutableTreeNode parent) {
        FileLoader fl = new FileLoader(parent);
        fl.execute();
    }

    private void treeExpand(TreePath tp) {
        DefaultMutableTreeNode dmtn = this.getTreeNode(tp);
        if (!this.loading.containsKey(dmtn)) {
            this.loading.put(dmtn, true);
            this.addChildren2(dmtn);
        }
    }

    class FileLoader
    extends SwingWorker<List<String>, String> {
        private DefaultMutableTreeNode parent;
        private int dirnum = 0;

        public FileLoader(DefaultMutableTreeNode parent) {
            this.parent = parent;
        }

        @Override
        protected List<String> doInBackground() throws Exception {
            ArrayList<String> dirs = new ArrayList<String>();
            ArrayList<String> fs = new ArrayList<String>();
            String path = ExplorerTree.this.getPath(ExplorerTree.this.getTreePath(this.parent));
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    if (f.isDirectory()) {
                        dirs.add(f.getName());
                        continue;
                    }
                    if (!f.isFile()) continue;
                    fs.add(f.getName());
                }
                this.dirnum = dirs.size();
                dirs.addAll(fs);
            }
            return dirs;
        }

        @Override
        protected void done() {
            try {
                List children = (List)this.get();
                this.parent.removeAllChildren();
                int i = 0;
                for (String ch : children) {
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(ch);
                    if (i < this.dirnum) {
                        ExplorerTree.this.addLoading(child);
                        ++i;
                    }
                    this.parent.add(child);
                }
                ExplorerTree.this.loading.remove(this.parent);
                ExplorerTree.this.updateUI();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
    }
}

