/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.NGSMLEditor;
import cn.edu.suda.ngsml.core.Parser;
import cn.edu.suda.ngsml.gui.AboutDialog;
import cn.edu.suda.ngsml.gui.ConvertFrame;
import cn.edu.suda.ngsml.gui.LabelHandler;
import cn.edu.suda.ngsml.gui.MergeFrame;
import cn.edu.suda.ngsml.gui.TreePane;
import cn.edu.suda.ngsml.io.NGSMLReader;
import cn.edu.suda.ngsml.io.NGSMLWriter;
import cn.edu.suda.ngsmllib.CheckFactory;
import cn.edu.suda.ngsmllib.NGSMLException;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class MainFrame
extends JFrame {
    private TreePane tree;
    private String filePath = "";
    private boolean saved = true;
    private JFileChooser jfc = new JFileChooser();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem10;
    private JMenuItem jMenuItem11;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JToolBar jToolBar1;
    private JLabel logLabel;

    public MainFrame() {
        this.initComponents();
        this.init();
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public void openFile(File file) {
        try {
            Document doc = NGSMLReader.getInstance().read(file);
            this.loadTree(Parser.parseDocToNode(doc));
            this.filePath = file.getAbsolutePath();
            this.checkValidate();
        }
        catch (DocumentException ex) {
            NGSMLEditor.getLogger().severe("Read file failed!");
        }
    }

    public int checkSaved() {
        if (!this.saved) {
            int re = JOptionPane.showConfirmDialog(null, "Save file?", "Save", 1);
            if (re == 0) {
                this.saveFile();
                return 0;
            }
            if (re == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private void init() {
        this.jfc.setFileFilter(new FileNameExtensionFilter("XML files", "xml"));
        NGSMLEditor.getLogger().addHandler(new LabelHandler(this.logLabel));
        NGSMLEditor.getLogger().info("Initialized successfully!");
        this.setLocationRelativeTo(null);
    }

    private void loadTree(DefaultMutableTreeNode root) {
        this.tree = new TreePane(this, root);
        this.jPanel1.removeAll();
        this.jPanel1.add(this.tree);
        this.jPanel1.updateUI();
    }

    private void newFile() {
        int re = this.checkSaved();
        if (re == 2) {
            return;
        }
        Document doc = CheckFactory.getInstance().buildNew();
        this.loadTree(Parser.parseDocToNode(doc));
        this.filePath = "";
        this.saved = false;
    }

    private void openFile() {
        int ree = this.checkSaved();
        if (ree == 2) {
            return;
        }
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(0);
        int re = this.jfc.showOpenDialog(null);
        if (re == 0) {
            File file = this.jfc.getSelectedFile();
            this.openFile(file);
        }
    }

    private void saveAsFile() {
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(0);
        int re = this.jfc.showSaveDialog(null);
        if (re == 0) {
            File file = this.jfc.getSelectedFile();
            try {
                NGSMLWriter.getInstance().write(Parser.parseNodeToDoc(this.tree.getRootNode()), file.getAbsolutePath());
                this.filePath = file.getAbsolutePath();
                this.saved = true;
                NGSMLEditor.getLogger().info("File is saved!");
            }
            catch (IOException ex) {
                NGSMLEditor.getLogger().severe("Write file failed!");
            }
        }
    }

    private void saveFile() {
        if (this.tree == null || this.tree.getRootNode() == null) {
            JOptionPane.showMessageDialog(null, "No file to save!");
            return;
        }
        this.checkValidate();
        if (this.filePath.isEmpty()) {
            this.saveAsFile();
        } else {
            try {
                NGSMLWriter.getInstance().write(Parser.parseNodeToDoc(this.tree.getRootNode()), this.filePath);
                this.saved = true;
                NGSMLEditor.getLogger().info("File is saved!");
            }
            catch (IOException ex) {
                NGSMLEditor.getLogger().severe("Write file failed!");
            }
        }
    }

    private void closeFile() {
        int re = this.checkSaved();
        if (re == 0 || re == 1) {
            this.tree.clear();
        }
    }

    private void checkValidate() {
        if (this.tree != null && this.tree.getRootNode() != null) {
            Document doc = Parser.parseNodeToDoc(this.tree.getRootNode());
            try {
                CheckFactory.getInstance().check(doc);
                NGSMLEditor.getLogger().info("File is correct!");
            }
            catch (NGSMLException ex) {
                NGSMLEditor.getLogger().severe(ex.getMessage() + "  XPATH: " + ex.getXpath());
            }
        }
    }

    private void exit() {
        if (!this.saved) {
            int re = this.checkSaved();
            if (re == 0 || re == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private void showAbout() {
        new AboutDialog((Frame)this, true).setVisible(true);
    }

    private void showHelp() {
        try {
            Desktop.getDesktop().open(new File("NGSMLEditor_manual.html"));
        }
        catch (IOException ex) {
            NGSMLEditor.getLogger().severe("Document do not exists!");
        }
    }

    private void showConverter() {
        ConvertFrame cf = new ConvertFrame(this);
        cf.setVisible(true);
    }

    private void showMerger() {
        MergeFrame mf = new MergeFrame();
        mf.setVisible(true);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jPanel1 = new JPanel();
        this.logLabel = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem5 = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem6 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem11 = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem9 = new JMenuItem();
        this.jMenuItem10 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("NGSMLEditor");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/new.png")));
        this.jButton1.setText("New");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setMaximumSize(new Dimension(55, 57));
        this.jButton1.setMinimumSize(new Dimension(55, 57));
        this.jButton1.setPreferredSize(new Dimension(55, 57));
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/open.png")));
        this.jButton2.setText("Open");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setMaximumSize(new Dimension(55, 57));
        this.jButton2.setMinimumSize(new Dimension(55, 57));
        this.jButton2.setPreferredSize(new Dimension(55, 57));
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/save.png")));
        this.jButton3.setText("Save");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setMaximumSize(new Dimension(55, 57));
        this.jButton3.setMinimumSize(new Dimension(55, 57));
        this.jButton3.setPreferredSize(new Dimension(55, 57));
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/validate.png")));
        this.jButton4.setText("Validate");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton4);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.logLabel.setText("Welcome");
        this.jMenu1.setText("File");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem1.setText("New");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem2.setText("Open...");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem3.setText("Save");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.jMenuItem4.setText("Save As...");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu1.add(this.jSeparator3);
        this.jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem5.setText("Validate");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem5ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu1.add(this.jSeparator2);
        this.jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem6.setText("Close");
        this.jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem6ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem6);
        this.jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem7.setText("Exit");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem7ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem7);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Format");
        this.jMenuItem8.setText("NGSML Converter");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem8ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem8);
        this.jMenuItem11.setText("NGS File Merger");
        this.jMenuItem11.setActionCommand("NGS File Merger");
        this.jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem11ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem11);
        this.jMenuItem11.getAccessibleContext().setAccessibleName("NGS File Merger");
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Help");
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItem9.setText("Document");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem9ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem9);
        this.jMenuItem10.setText("About...");
        this.jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jMenuItem10ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem10);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 553, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.logLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 323, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logLabel).addContainerGap()));
        this.logLabel.getAccessibleContext().setAccessibleName("logLabel");
        this.pack();
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        this.openFile();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.openFile();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.saveAsFile();
    }

    private void jMenuItem6ActionPerformed(ActionEvent evt) {
        this.closeFile();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.newFile();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.checkValidate();
    }

    private void jMenuItem5ActionPerformed(ActionEvent evt) {
        this.checkValidate();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        this.newFile();
    }

    private void jMenuItem7ActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void jMenuItem10ActionPerformed(ActionEvent evt) {
        this.showAbout();
    }

    private void jMenuItem9ActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    private void jMenuItem8ActionPerformed(ActionEvent evt) {
        this.showConverter();
    }

    private void jMenuItem11ActionPerformed(ActionEvent evt) {
        this.showMerger();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

