/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.gui.ExplorerTree;
import cn.edu.suda.ngsml.gui.LabelHandler;
import cn.edu.suda.ngsml.gui.MergeWorker;
import cn.edu.suda.ngsml.util.FileHelper;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;

public class MergeFrame
extends JFrame {
    public static final String[] FORMATS = new String[]{"FASTA", "FASTQ"};
    private static final Logger LOG = Logger.getLogger(MergeFrame.class.getName());
    private JFileChooser jfc;
    private ExplorerTree tree;
    private int mx;
    private int my;
    private int processPos = 0;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextField jTextField1;
    private JToolBar jToolBar1;

    public MergeFrame() {
        this.initComponents();
        this.init();
    }

    public static Logger getLogger() {
        return LOG;
    }

    public void updateNextStatus(String status) {
        this.jTable1.setValueAt(status, this.processPos, 4);
        ++this.processPos;
    }

    public void updateProgressbar(int n, int sum) {
        float percent = (float)n / (float)sum;
        this.jProgressBar1.setValue((int)(percent * (float)this.jProgressBar1.getMaximum()));
    }

    public void add(File file) {
        if (!file.isFile()) {
            return;
        }
        int id = this.jTable1.getRowCount() + 1;
        ((DefaultTableModel)this.jTable1.getModel()).addRow(new Object[]{id, file.getName(), FileHelper.getFileSize(file), file.getAbsolutePath(), "Ready"});
    }

    public void addAll(File file) {
        if (!file.isDirectory()) {
            return;
        }
        for (File f : file.listFiles()) {
            this.add(f);
        }
    }

    public void remove() {
        int r = this.jTable1.getSelectedRow();
        if (r >= 0) {
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(r);
            this.sortID();
        }
    }

    public void clear() {
        if (this.jTable1.getRowCount() <= 0) {
            return;
        }
        for (int i = this.jTable1.getRowCount() - 1; i >= 0; --i) {
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(i);
        }
    }

    public void start() {
        String[] inputs = this.getInputs();
        if (inputs.length == 0) {
            return;
        }
        for (int i = 0; i < inputs.length; ++i) {
            this.jTable1.setValueAt("Ready", i, 4);
        }
        this.processPos = 0;
        String output = this.jTextField1.getText().trim();
        if (output.isEmpty()) {
            return;
        }
        String type = FORMATS[this.jComboBox1.getSelectedIndex()];
        MergeWorker mw = new MergeWorker(inputs, Converter.FileType.valueOf(type), output, this);
        this.jProgressBar1.setValue(0);
        this.setRunningState(true);
        mw.execute();
    }

    public String[] getInputs() {
        String[] inputs = new String[this.jTable1.getRowCount()];
        for (int i = 0; i < this.jTable1.getRowCount(); ++i) {
            inputs[i] = this.jTable1.getValueAt(i, 3).toString();
        }
        return inputs;
    }

    private void init() {
        this.initTree();
        this.jfc = new JFileChooser();
        this.jTable1.setSelectionMode(0);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(FORMATS));
        this.jProgressBar1.setVisible(true);
        this.setLocationRelativeTo(null);
        LOG.addHandler(new LabelHandler(this.jLabel3));
        LOG.info("Ready.");
    }

    public void setRunningState(boolean running) {
        this.jButton1.setEnabled(!running);
        this.jButton2.setEnabled(!running);
        this.jButton3.setEnabled(!running);
        this.jButton4.setEnabled(!running);
        this.jButton5.setEnabled(!running);
        this.jButton6.setEnabled(!running);
        this.jComboBox1.setEnabled(!running);
        this.tree.setEnabled(!running);
        this.jProgressBar1.setVisible(running);
    }

    private void sortID() {
        int r = this.jTable1.getRowCount();
        for (int i = 0; i < r; ++i) {
            this.jTable1.setValueAt(i + 1, i, 0);
        }
    }

    private void addButton() {
        this.jfc.setMultiSelectionEnabled(true);
        this.jfc.setFileSelectionMode(0);
        int re = this.jfc.showOpenDialog(this);
        if (re == 0) {
            for (File f : this.jfc.getSelectedFiles()) {
                this.add(f);
            }
        }
    }

    private void addAllButton() {
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(1);
        int re = this.jfc.showOpenDialog(this);
        if (re == 0) {
            this.addAll(this.jfc.getSelectedFile());
        }
    }

    private void browseOutput() {
        this.jfc.setMultiSelectionEnabled(false);
        this.jfc.setFileSelectionMode(0);
        int re = this.jfc.showSaveDialog(this);
        if (re == 0) {
            this.jTextField1.setText(this.jfc.getSelectedFile().getAbsolutePath());
        }
    }

    private void initTree() {
        this.tree = new ExplorerTree();
        this.jScrollPane2.setViewportView(this.tree);
        final JPopupMenu pop = new JPopupMenu();
        JMenuItem add = new JMenuItem("Add file");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = MergeFrame.this.tree.getPath(MergeFrame.this.tree.getFromXY(MergeFrame.this.mx, MergeFrame.this.my));
                File file = new File(path);
                if (file.isFile()) {
                    MergeFrame.this.add(file);
                } else if (file.isDirectory()) {
                    MergeFrame.this.addAll(file);
                }
            }
        });
        pop.add(add);
        JMenuItem refresh = new JMenuItem("Refresh");
        refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeFrame.this.tree.refresh(MergeFrame.this.tree.getFromXY(MergeFrame.this.mx, MergeFrame.this.my));
            }
        });
        pop.add(refresh);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    MergeFrame.this.mx = e.getX();
                    MergeFrame.this.my = e.getY();
                    MergeFrame.this.tree.setSelectionPath(MergeFrame.this.tree.getFromXY(MergeFrame.this.mx, MergeFrame.this.my));
                    pop.show(e.getComponent(), MergeFrame.this.mx, MergeFrame.this.my);
                }
            }
        });
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton6 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jLabel3 = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.setTitle("FileFusion");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/add.png")));
        this.jButton1.setText("Add");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setMaximumSize(new Dimension(43, 57));
        this.jButton1.setMinimumSize(new Dimension(43, 57));
        this.jButton1.setPreferredSize(new Dimension(43, 57));
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/addall.png")));
        this.jButton2.setText("AddAll");
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/remove.png")));
        this.jButton3.setText("Remove");
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton3ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/removeall.png")));
        this.jButton4.setText("Clear");
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setMaximumSize(new Dimension(43, 57));
        this.jButton4.setMinimumSize(new Dimension(43, 57));
        this.jButton4.setPreferredSize(new Dimension(43, 57));
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton4ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton4);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/cn/edu/suda/ngsml/ico/start.png")));
        this.jButton5.setText("Start");
        this.jButton5.setFocusable(false);
        this.jButton5.setHorizontalTextPosition(0);
        this.jButton5.setMaximumSize(new Dimension(43, 57));
        this.jButton5.setMinimumSize(new Dimension(43, 57));
        this.jButton5.setPreferredSize(new Dimension(43, 57));
        this.jButton5.setVerticalTextPosition(3);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton5ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton5);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Name", "Size", "Path", "Status"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jLabel1.setText("FileType: ");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Output File: ");
        this.jButton6.setText("Browse");
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergeFrame.this.jButton6ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Ready");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 642, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jProgressBar1, -1, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBox1, -2, 100, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton6))))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 185, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox1, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton6)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.jScrollPane2))).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addButton();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.addAllButton();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.remove();
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.start();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.browseOutput();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MergeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MergeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MergeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MergeFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MergeFrame().setVisible(true);
            }
        });
    }
}

