/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.MergeFactory;
import cn.edu.suda.ngsml.core.conversion.Merger;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.gui.MergeFrame;
import cn.edu.suda.ngsml.io.NGSIOFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

public class MergeWorker
extends SwingWorker<String, String> {
    private String[] inputs;
    private Converter.FileType filetype;
    private String output;
    private String time = "";
    private MergeFrame frame;

    public MergeWorker(String[] inputs, Converter.FileType filetype, String output, MergeFrame frame) {
        this.inputs = inputs;
        this.filetype = filetype;
        this.output = output;
        this.frame = frame;
    }

    @Override
    protected String doInBackground() throws Exception {
        long t1 = System.currentTimeMillis();
        Merger merger = null;
        merger = MergeFactory.getInstance().getMerger(this.filetype);
        String type = this.filetype.toString();
        if (merger != null) {
            int i = 0;
            ArrayList<NGSFile> files = new ArrayList<NGSFile>();
            for (String in : this.inputs) {
                ++i;
                try {
                    files.add(NGSIOFactory.getInstance().read(in, type));
                    this.setProgress(i);
                }
                catch (Exception ex2) {
                    this.publish("Failed");
                    MergeFrame.getLogger().severe(ex2.getMessage());
                }
            }
            try {
                NGSFile[] array = new NGSFile[files.size()];
                array = files.toArray(array);
                Object outfile = merger.merge(array);
                NGSIOFactory.getInstance().write((NGSFile)outfile, this.output);
                this.publish("Finish");
            }
            catch (Exception ex) {
                MergeFrame.getLogger().severe(ex.getMessage());
            }
        } else {
            MergeFrame.getLogger().severe("Failed!");
        }
        long t2 = System.currentTimeMillis();
        float f = (float)(t2 - t1) / 1000.0f;
        this.time = f + " s";
        return this.output;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String s : chunks) {
            this.frame.updateNextStatus(s);
        }
        this.frame.updateProgressbar(this.getProgress(), this.inputs.length + 1);
    }

    @Override
    protected void done() {
        this.frame.setRunningState(false);
        MergeFrame.getLogger().info("Done! Time: " + this.time);
    }
}

