/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.gui;

import cn.edu.suda.ngsml.core.DataType;
import cn.edu.suda.ngsml.core.NGSMLEditor;
import cn.edu.suda.ngsml.core.XMLData;
import cn.edu.suda.ngsml.gui.CellRenderer;
import cn.edu.suda.ngsml.gui.MainFrame;
import cn.edu.suda.ngsml.gui.Resource;
import cn.edu.suda.ngsmllib.CheckFactory;
import cn.edu.suda.ngsmllib.Checker;
import cn.edu.suda.ngsmllib.NGSMLException;
import cn.edu.suda.ngsmllib.node.NGSAttribute;
import cn.edu.suda.ngsmllib.node.NGSElement;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePane
extends JPanel
implements ActionListener {
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private JPopupMenu popup;
    private JMenu add;
    private MainFrame frame;
    private Checker checker = null;

    public TreePane(MainFrame frame, DefaultMutableTreeNode root) {
        super(new GridLayout(1, 0));
        this.frame = frame;
        this.initPopup();
        this.rootNode = root;
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selrow = TreePane.this.tree.getRowForLocation(e.getX(), e.getY());
                if (selrow != -1 && e.getButton() == 3) {
                    TreePane.this.tree.setSelectionRow(selrow);
                    TreePane.this.showPopup(e.getX(), e.getY());
                }
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePane.this.changeMenu();
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new CellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.add(scrollPane);
    }

    public TreePane() {
        this(null, null);
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public void clear() {
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
        }
    }

    public DefaultMutableTreeNode addObject(XMLData data, int index) {
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, data, index, true);
    }

    public DefaultMutableTreeNode addObject(XMLData data) {
        TreePath parentPath = this.tree.getSelectionPath();
        DefaultMutableTreeNode parentNode = parentPath == null ? this.rootNode : (DefaultMutableTreeNode)parentPath.getLastPathComponent();
        return this.addObject(parentNode, data, true);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, XMLData data, boolean shouldBeVisible) {
        return this.addObject(parent, data, parent.getChildCount(), shouldBeVisible);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, XMLData data, int index, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(data);
        if (parent == null) {
            parent = this.rootNode;
        }
        if (index > parent.getChildCount()) {
            index = parent.getChildCount();
        }
        this.treeModel.insertNodeInto(childNode, parent, index);
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, XMLData data) {
        return this.addObject(parent, data, false);
    }

    private void initPopup() {
        this.popup = new JPopupMenu();
        this.add = new JMenu("Add");
        JMenuItem edit = new JMenuItem("Edit");
        edit.addActionListener(this);
        JMenuItem delete = new JMenuItem("Delete");
        delete.addActionListener(this);
        JMenuItem collapse = new JMenuItem("Collapse");
        collapse.addActionListener(this);
        JMenuItem expand = new JMenuItem("Expand");
        expand.addActionListener(this);
        this.popup.add(this.add);
        this.popup.add(edit);
        this.popup.add(delete);
        this.popup.add(collapse);
        this.popup.add(expand);
    }

    private void changeMenu() {
        JMenuItem mi;
        String[] list;
        if (this.tree.getSelectionCount() <= 0) {
            return;
        }
        this.add.removeAll();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        XMLData data = (XMLData)node.getUserObject();
        if (data.getType() == DataType.Namespace) {
            this.checker = null;
            return;
        }
        String xpath = data.getXpath();
        try {
            this.checker = CheckFactory.getInstance().find(xpath);
        }
        catch (NGSMLException ex) {
            NGSMLEditor.getLogger().severe(ex.getMessage());
            this.checker = null;
            return;
        }
        if (this.checker == null) {
            return;
        }
        for (String s : list = this.checker.listAttrs()) {
            if (this.isAttributeExist(node, s)) continue;
            mi = new JMenuItem(s);
            mi.setIcon(Resource.getInstance().ATTRIBUTE_ICON);
            mi.addActionListener(this);
            this.add.add(mi);
        }
        for (String s : list = this.checker.listElements()) {
            if (this.isElementExist(node, s)) {
                try {
                    Checker c = CheckFactory.getInstance().find(xpath + "/" + s);
                    int max = ((NGSElement)c.getNode()).getMaxCount();
                    if (max <= 1) {
                        continue;
                    }
                }
                catch (NGSMLException c) {
                    // empty catch block
                }
            }
            mi = new JMenuItem(s);
            mi.setIcon(Resource.getInstance().ELEMENT_ICON);
            mi.addActionListener(this);
            this.add.add(mi);
        }
    }

    private boolean isAttributeExist(DefaultMutableTreeNode node, String attr) {
        Enumeration<TreeNode> enu = node.children();
        while (enu.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enu.nextElement();
            XMLData data = (XMLData)child.getUserObject();
            if (data.getType() != DataType.Attribute || !data.getName().equals(attr)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementExist(DefaultMutableTreeNode node, String element) {
        Enumeration<TreeNode> enu = node.children();
        while (enu.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enu.nextElement();
            XMLData data = (XMLData)child.getUserObject();
            if (data.getType() != DataType.Element || !data.getName().equals(element)) continue;
            return true;
        }
        return false;
    }

    private void showPopup(int x, int y) {
        this.popup.show(this.tree, x, y);
    }

    private void addCommand(String cmd) {
        if (this.checker.hasAttr(cmd)) {
            String xpath = this.checker.getXpath() + "/@" + cmd;
            try {
                Checker c = CheckFactory.getInstance().find(xpath);
                String defaultValue = ((NGSAttribute)c.getNode()).getDefaultValue();
                XMLData data = new XMLData(cmd, defaultValue, DataType.Attribute, xpath);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                int attrnum = 0;
                for (String attr : this.checker.listAttrs()) {
                    if (!this.isAttributeExist(node, attr)) continue;
                    ++attrnum;
                }
                this.addObject(data, attrnum);
            }
            catch (NGSMLException ex) {
                NGSMLEditor.getLogger().severe(ex.getMessage());
            }
        } else {
            String xpath = this.checker.getXpath() + "/" + cmd;
            try {
                Checker c = CheckFactory.getInstance().find(xpath);
                XMLData data = new XMLData(cmd, "", DataType.Element, xpath);
                int seqno = ((NGSElement)c.getNode()).getSeqno();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                int attrnum = 0;
                for (String attr : this.checker.listAttrs()) {
                    if (!this.isAttributeExist(node, attr)) continue;
                    ++attrnum;
                }
                if (seqno == 0) {
                    int no = 0;
                    for (String ele : this.checker.listElements()) {
                        if (!this.isElementExist(node, ele)) continue;
                        String xpath2 = this.checker.getXpath() + "/" + ele;
                        Checker cc = CheckFactory.getInstance().find(xpath2);
                        int seqno2 = ((NGSElement)cc.getNode()).getSeqno();
                        if (seqno2 > seqno) continue;
                        ++no;
                    }
                    if (this.checker.getXpath().equals("/ngs")) {
                        ++no;
                    }
                    this.addObject(data, no + attrnum);
                } else if (seqno == -1) {
                    this.addObject(data);
                } else {
                    int no = 0;
                    for (String ele : this.checker.listElements()) {
                        if (!this.isElementExist(node, ele)) continue;
                        String xpath2 = this.checker.getXpath() + "/" + ele;
                        Checker cc = CheckFactory.getInstance().find(xpath2);
                        int seqno2 = ((NGSElement)cc.getNode()).getSeqno();
                        if (seqno2 > seqno) continue;
                        ++no;
                    }
                    if (this.checker.getXpath().equals("/ngs")) {
                        ++no;
                    }
                    this.addObject(data, no + attrnum);
                }
            }
            catch (NGSMLException ex) {
                NGSMLEditor.getLogger().severe(ex.getMessage());
            }
        }
        this.changeMenu();
        if (this.frame != null) {
            this.frame.setSaved(false);
        }
    }

    private void editCommand() {
        TreePath tp = this.tree.getSelectionPath();
        if (this.checker == null) {
            NGSMLEditor.getLogger().info("Namespace can't edit!");
            return;
        }
        if (this.checker.isAttr()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            XMLData data = (XMLData)node.getUserObject();
            String currentValue = data.getValue();
            if (currentValue == null) {
                currentValue = "";
            }
            String re = "";
            Object[] options = new Object[]{currentValue};
            re = (String)JOptionPane.showInputDialog(null, "Please input the value:", "Attribute Editor", 3, null, null, options[0]);
            if (re != null && this.checker.getAttrType().isValid(re)) {
                data.setValue(re);
                this.treeModel.reload();
                this.tree.makeVisible(tp);
            } else if (re != null) {
                JOptionPane.showMessageDialog(null, "Invalid Type!", "Error", 0);
            }
        } else if (((NGSElement)this.checker.getNode()).isText()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            XMLData data = (XMLData)node.getUserObject();
            String currentValue = data.getValue();
            if (currentValue == null) {
                currentValue = "";
            }
            String re = "";
            Object[] options = new Object[]{currentValue};
            re = (String)JOptionPane.showInputDialog(null, "Please input the value:", "Element Editor", 3, null, null, options[0]);
            if (re != null) {
                data.setValue(re);
                this.treeModel.reload();
                this.tree.makeVisible(tp);
            }
        }
        if (this.frame != null) {
            this.frame.setSaved(false);
        }
    }

    private void deleteCommand() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        node.removeFromParent();
        this.treeModel.reload();
        if (this.frame != null) {
            this.frame.setSaved(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String txt;
        switch (txt = e.getActionCommand()) {
            case "Edit": {
                this.editCommand();
                break;
            }
            case "Delete": {
                this.deleteCommand();
                break;
            }
            case "Collapse": {
                this.tree.collapsePath(this.tree.getSelectionPath());
                break;
            }
            case "Expand": {
                this.tree.expandPath(this.tree.getSelectionPath());
                break;
            }
            default: {
                this.addCommand(e.getActionCommand());
            }
        }
    }
}

