/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.io;

import cn.edu.suda.ngsml.core.conversion.Converter;
import cn.edu.suda.ngsml.core.conversion.FastaFile;
import cn.edu.suda.ngsml.core.conversion.FastqFile;
import cn.edu.suda.ngsml.core.conversion.GFF3File;
import cn.edu.suda.ngsml.core.conversion.NGSFile;
import cn.edu.suda.ngsml.core.conversion.SAMFile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class NGSIOFactory {
    private static final NGSIOFactory INSTANCE = new NGSIOFactory();

    private NGSIOFactory() {
    }

    public static NGSIOFactory getInstance() {
        return INSTANCE;
    }

    public NGSFile read(String file, String type) throws IOException {
        Converter.FileType filetype = Converter.FileType.valueOf(type);
        switch (filetype) {
            case FASTA: {
                return new FastaFile().read(file);
            }
            case FASTQ: {
                return new FastqFile().read(file);
            }
            case SAM: {
                return new SAMFile().read(file);
            }
            case GFF3: {
                return new GFF3File().read(file);
            }
        }
        return null;
    }

    public void write(NGSFile file, String filePath) throws IOException {
        if (file.isText()) {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(filePath)), "UTF-8"));
            bw.write(file.toString());
            bw.close();
        } else {
            BufferedOutputStream bs = new BufferedOutputStream(new FileOutputStream(filePath));
            bs.write(file.toBytes());
            bs.close();
        }
    }
}

