/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.suda.ngsml.util;

import java.io.File;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileHelper {
    public static String getParentPath(String file) {
        File f = new File(file);
        return f.getParent();
    }

    public static String getNameWithoutSuffix(String file) {
        File f = new File(file);
        String name = f.getName();
        int dot = name.lastIndexOf(".");
        if (dot == -1) {
            return name;
        }
        return name.substring(0, dot);
    }

    public static String getFileName(String file) {
        File f = new File(file);
        String name = f.getName();
        return name;
    }

    public static String getSuffix(String filename) {
        return filename.substring(filename.lastIndexOf(".") + 1, filename.length());
    }

    public static String getFileSize(File file) {
        long size = file.length();
        if (size < 1024L) {
            return size + "B";
        }
        double s = size / 1024L;
        if (s < 1024.0) {
            BigDecimal bm = new BigDecimal(s);
            s = bm.setScale(2, 4).doubleValue();
            return s + "KB";
        }
        if ((s /= 1024.0) < 1024.0) {
            BigDecimal bm = new BigDecimal(s);
            s = bm.setScale(2, 4).doubleValue();
            return s + "MB";
        }
        BigDecimal bm = new BigDecimal(s /= 1024.0);
        s = bm.setScale(2, 4).doubleValue();
        return s + "GB";
    }

    private FileHelper() {
    }

    public static String read(String fileName) throws Exception {
        StringBuilder strbu = new StringBuilder();
        int bufSize = 0xA00000;
        byte[] bs = new byte[bufSize];
        ByteBuffer byteBuf = ByteBuffer.allocate(0xA00000);
        FileChannel channel = new RandomAccessFile(fileName, "r").getChannel();
        while (channel.read(byteBuf) != -1) {
            int size = byteBuf.position();
            byteBuf.rewind();
            byteBuf.get(bs);
            strbu.append(new String(bs, 0, size));
            byteBuf.clear();
        }
        return strbu.toString();
    }
}

